/* Agent Tcl
   Bob Gray
   4 September 1995

   map.h

   This file defines the class which associates pointers with related pointers.
*/

#ifndef _MAP_H
#define _MAP_H

#include <stdio.h>
#include <stdlib.h>
#include "tcl.h"

class POINTER_MAP
{
      /* hash table keyed on addresses */

    Tcl_HashTable table;     

  public:

      /* add, lookup and remove */

    inline void add (void *ptr1, void *ptr2) {

      int dummy;
      Tcl_HashEntry *entry;

        /* create the entry in the hash table */

      entry = Tcl_CreateHashEntry (&table, (char *) ptr1, &dummy);
      Tcl_SetHashValue (entry, (ClientData) ptr2);
    };

    inline void *lookup (void *ptr) {

      Tcl_HashEntry *entry;

        /* find the entry in the hash table */

      if ((entry = Tcl_FindHashEntry (&table, (char *) ptr)) == NULL) {
        return NULL;
      } else { 
        return ((void *) Tcl_GetHashValue (entry));
      }
    };
 
    inline void remove (void *ptr) {

      Tcl_HashEntry *entry;

        /* delete the entry if it exists */

      if ((entry = Tcl_FindHashEntry (&table, (char *) ptr)) == NULL) {
        Tcl_DeleteHashEntry (entry);
      }
    };

       /* construcor and destructor */

    POINTER_MAP (void) {
      Tcl_InitHashTable (&table, TCL_ONE_WORD_KEYS);
    };

   ~POINTER_MAP () {
      Tcl_DeleteHashTable (&table);
    };
};

#endif
