/* Agent Tcl
   Bob Gray
   9 Februrary 1995

   message.h

   This file defines the data structures and flags associated with
   internal messages.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _MESSAGE_H
#define _MESSAGE_H

#include "my_sizes.h"

  /* maximum number of elements in a message */

const MAX_ELEMENTS = 11;

  /* element types */

const MESG_TYPE_STR	= 0;
const MESG_TYPE_LONG	= 1;
const MESG_TYPE_BYTE	= 2;
const MESG_TYPE_SHORT	= 3;
const MESG_TYPE_IP	= 4;
const MESG_TYPE_BINARY  = 5;
const MESG_TYPE_IDS     = 6;
const MESG_TYPE_NAMES	= 7;

  /* request flags */

const REQ_BEGIN		= 0;
const REQ_NAME		= 1;
const REQ_END		= 2;
const REQ_SCRIPT	= 3;
const REQ_STATE		= 4;
const REQ_MESSAGE	= 5;
const REQ_MEETING	= 6;
const REQ_EVENT		= 7;
const REQ_GET		= 8;
const REQ_ENCRYPT	= 9;
const REQ_INFO		= 10;
const REQ_SIGN		= 11;
const NUM_REQUESTS	= 12;

  /* response flags */

const RESP_ID		= 0;
const RESP_OK		= 1;
const RESP_ERROR	= 2;
const RESP_MESSAGE	= 3;
const RESP_MEETING	= 4;
const RESP_EVENT	= 5;
const RESP_NONE		= 6;
const RESP_IDS		= 7;
const RESP_NAMES	= 8;
const RESP_INFO		= 9;
const NUM_RESPONSES	= 10;

  /* interpreter message flags */

const INTERP_SCRIPT	= 0;
const INTERP_STATE	= 1;
const NUM_INTERP	= 2;

  /* how an agent ends */

const END_NORMAL	= 0;
const END_FORCE		= 1;

  /* information that can be requested from the server */

const INFO_ALL_IDS	= 0;
const INFO_ALL_NAMES	= 1;
const INFO_ID		= 2;
 
  /* structure that contains a message type */

struct MESSAGE_TYPE
{
  UINT_8 flag;                  /* message flag       */
  int n;                        /* number of elements */
  UINT_8 types[MAX_ELEMENTS];   /* types of elements  */
};

  /* strcuture that contains a message element */

struct MESSAGE_ELEMENT
{
  int dealloc;          /* TRUE if the string should be deallocated */
  UINT_32 number;       /* value is here if the element is numeric  */
  char *string;         /* value is here if the element is a string */
};

  /* structure that contains a message */

struct MESSAGE 
{
  char *buffer;                            /* message buffer        */
  UINT_8 flag;                             /* message flag          */ 
  int n;                                   /* number of elements    */
  UINT_8 types[MAX_ELEMENTS];              /* types of the elements */
  MESSAGE_ELEMENT elements[MAX_ELEMENTS];  /* the elements          */

    /* constructors and destructor */

  MESSAGE (const MESSAGE_TYPE &type);
 ~MESSAGE ();
};

  /* structure that contains a SET of message types */

struct MESSAGE_SET
{
  int n;                    /* number of messages in the set */
  MESSAGE_TYPE *messages;   /* the messages                  */
};
    
  /* SETS of message types */

extern MESSAGE_SET up_socket;
extern MESSAGE_SET up_pipe;
extern MESSAGE_SET down_pipe;
extern MESSAGE_SET down_socket;
extern MESSAGE_SET to_interpreter;

  /* map messages from socket form to pipe form */

MESSAGE *map_message_to_pipe (MESSAGE *message);

  /* map messages from pipe form to socket form */

MESSAGE *map_message_to_socket (MESSAGE *message);

#endif
