/* Agent Tcl
   Bob Gray
   8 September 1995

   my_alloc.h

   This file defines routines for allocating and freeing memory.
*/

#ifndef _MY_ALLOC_H
#define _MY_ALLOC_H

#include <stdlib.h>

  /* two simplified memcpy's */

inline char *fast_memcpy (char *dp, char *sp, unsigned size)
{
  register unsigned i;

  for (i = 0; i < size; i++) {
    *dp++ = *sp++;
  }

  return dp;
}

inline char *fast_src_memcpy (char *dp, char *sp, unsigned size)
{
  register unsigned i;

  for (i = 0; i < size; i++) {
    *dp++ = *sp++;
  }

  return sp;
}
 
  /* delete but check for NULL */

#define delete_check(ptr) { \
  if (ptr != NULL) { \
    delete ptr; \
  } \
} 

#endif
