/* Agent Tcl
   Bob Gray
   11 July 1995

   my_sizes.h

   This file defines the INT_8, INT_16 and INT_32 types and the ranges of
   these types.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _MY_SIZES_H
#define _MY_SIZES_H

#define INT_8	signed char
#define INT_16	signed short
#define INT_32	signed int

#define UINT_8	unsigned char
#define UINT_16	unsigned short
#define UINT_32 unsigned int

#ifdef __cplusplus

const MAX_8   = 0x7f;
const MIN_8   = 0x80;
const MAX_U8  = 0xff;
const MAX_16  = 0x7fff;
const MIN_16  = 0x8000;
const MAX_U16 = 0xffff;
const MAX_32  = 0x7fffffff;
const MIN_32  = 0x80000000;
const MAX_U32 = 0xffffffff;

#else

#define MAX_8 	0x7f
#define	MIN_8	0x80
#define	MAX_U8	0xff
#define	MAX_16	0x7fff
#define	MIN_16	0x8000
#define	MAX_U16	0xffff
#define	MAX_32	0x7fffffff
#define	MIN_32	0x80000000
#define MAX_U32	0xffffffff

#endif
#endif
