/* Agent Tcl
   Bob Gray
   25 June 1995

   my_strings.cc

   This file implements various string utilities.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "my_strings.h"

  /* strip the whitespace off a string */

char *strip_whitespace (const char *string)
{
  char *spd;
  int length;
  char *new_string;
  const char *sp;

    /* nothing to do for NULL strings */
  
  if (string == NULL) {
    return NULL;
  }

    /* tear off the leading whitespace */

  for (sp = string; (*sp == ' ') || (*sp == '\t') || (*sp == '\n'); sp++);

  length = strlen(sp);
  new_string = new char [length + 1];
  strcpy (new_string, sp);

    /* tear off the trailing whitespace */

  for (spd = new_string + length - 1; spd >= new_string; spd--) {
    if ((*spd == ' ') || (*spd == '\t') || (*spd == '\n')) {
      *spd = '\0';
    } else {
      break;
    }
  }

  return new_string;
}
  
  /* copy a string */

char *my_strcpy (const char *string)
{
  char *copy = NULL;

  if (string != NULL) {
    copy = new char [strlen(string) + 1];
    strcpy (copy, string);
  }

  return copy;
}

  /* compare two strings */

int my_strcmp (const char *s1, const char *s2)
{
  if ((s1 == NULL) || (s2 == NULL)) {
    if ((s1 == NULL) && (s2 == NULL)) {
      return 0;
    } else if (s1 == NULL) {
      return -1;
    } else {
      return 1;
    }
  }

  return (strcmp(s1,s2));
}
