/* Agent Tcl
   Bob Gray
   1 September 1995

   queue.h

   This file defines a FIFO or queue.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _QUEUE_H
#define _QUEUE_H

  /* minimum and initial queue size */

const DEFAULT_QUEUE_SIZE = 8;
const MINIMUM_QUEUE_SIZE = 8;

  /* shrink or expand */

const QUEUE_EXPAND = 0;
const QUEUE_SHRINK = 1;

  /* FIFO or queue */

class QUEUE
{
  void **elements;     /* elements                                      */
  int count;           /* number of elements in the queue               */   
  int slots;           /* number of slots in the queue                  */
  int shrink_count;    /* number of elements at which queue is halved   */ 
  int expand_count;    /* number of elements at which queue is expanded */ 
  int head;            /* head of the queue (an index into "elements")  */
  int tail;            /* tail of the queue (an index into "elements")  */

    /* resize the queue */

  void resize_queue (int which);

 public:

    /* get the number of items in the queue */

  inline int get_count (void) {
    return count;
  }

    /* constructor and destructor */

  QUEUE (void);
 ~QUEUE ();

    /* push, enqueue and dequeue */

  void push (void *item);
  void enqueue (void *item);
  void *dequeue (void);

    /* peek at queue element i */

  void *peek (int i);
};

#endif     
