/* Agent Tcl
   Bob Gray
   14 August 1995 

   redirect.cc

   This file implements the procedure that redirects stdin, stdout and stderr.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/


#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include "redirect.h"

  /* close all open files except for stdin, stdout and stderr */
  /* redirect stdin, stderr and stdout to /dev/null           */

int fileRedirect (void)
{
  int fd;

     /* close open files */

  for (fd = 0; fd < 4096; fd++) {
    close (fd);
  }

  errno = 0;

    /* redirect stdin */

  if ((fd = open ("/dev/null", O_RDONLY)) < 0) {
    return -1;
  }

  if (fd != 0) {
    dup2 (fd, 0);
    close (fd);
  }

     /* redirect stdout and stderr */

  if ((fd = open ("/dev/null", O_WRONLY)) < 0) {
    return -1;
  }

  if (fd != 1) {
    dup2 (fd, 1);
    close (fd);
  }

  dup2 (1, 2);
  return 0;
}
