/* Agent Tcl
   Bob Gray
   29 September 1995

   sigio.h

   This file defines the class which handles the SIGIO interrupt.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SIGIO_H
#define _SIGIO_H

  /* client data */

typedef void *SigioClientData;

  /* function that is called when SIGIO fires */

typedef void (*SigioFunc) (SigioClientData);

  /* interrupt handler for SIGIO */

void sigio_handler (int signo);

  /* SIGIO handler */

class SIGIO_HANDLER
{
      /* sigio_handler can access any member of this class */

    friend void sigio_handler (int);

      /* static data */

    static int count;              /* number of instances of this class */
    static SIGIO_HANDLER *head;    /* head of the list of instances     */

      /* instance data */
 
    SIGIO_HANDLER *previous;       /* previous instance in the list     */
    SIGIO_HANDLER *next;           /* next instance in the list         */
    SigioClientData data;          /* client data                       */
    SigioFunc function;            /* handler function                  */

  public:

      /* constructor and destructor */

    SIGIO_HANDLER (SigioFunc function, SigioClientData data);
   ~SIGIO_HANDLER ();
};

#endif
