/* Agent Tcl
   Bob Gray
   9 March 1995

   stream_pipe.cc

   This function implements the "stream_pipe" function.  This function is
   based on the examples in "UNIX Network Programming" by W. Richard 
   Stevens [Prentice-Hall, 1990].

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <sys/types.h>
#include <sys/socket.h>
#include "truefalse.h"

/* stream_pipe

   Purpose: Create a stream pipe

     Input: None

    Output: The procedure returns -1 on error.  Otherwise the procedure
            sets fd[0] to one end of the stream pipe, sets fd[1] to the
            other end of the stream pipe and returns 0.
*/

int stream_pipe (int *fd)
{
  return (socketpair (AF_UNIX, SOCK_STREAM, 0, fd));
}
