/* Agent Tcl
   Bob Gray
   26 June 1995

   tcpip.h

   This file defines the routines that handle TCP/IP onnections.  These
   routines are based on the examples in [W. Richard Stevens, Unix Network
   Programming, Prentice Hall, 1990] and on the code that Saurab Nog
   developed as part of his A.I. project.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCPIP_H
#define _TCPIP_H

#include <sys/types.h>
#include <netinet/in.h>
#include "my_sizes.h"

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

  /* maximum backlog and the any port constant */

const TCPIP_BACKLOG  = 5;
const TCPIP_ANY_PORT = 0;
const UNKNOWN_IP     = 0;

  /* setup a socket */

const TCPIP_UNABLE_TO_CREATE       = -1;
const TCPIP_UNABLE_TO_BIND         = -2;
const TCPIP_UNABLE_TO_LISTEN       = -3;
const TCPIP_UNABLE_TO_GET_PORT     = -4;
const TCPIP_UNABLE_TO_ACCEPT       = -5;
const TCPIP_UNABLE_TO_CONVERT_NAME = -6;
const TCPIP_UNABLE_TO_CONNECT      = -7;
const TCPIP_TIMEOUT		   = -8;
const TCPIP_FCNTL		   = -9;

   /* create THEN bind THEN listen in INTERNET or UNIX domain */

int tcpip_setup		
	(int port, int *selected_port);

int tcpip_unix_setup	
	(char *name);

   /* socket, bind and connect in INTERNET or UNIX domain */

int tcpip_socket	
	(void);

int tcpip_connect	
	(int sockfd, char *server, UINT_32 server_ip, int port, clock_t stop);

int tcpip_bind		
	(int sockfd, int port, int *selected_port);

int tcpip_unix_socket	
	(void);

int tcpip_unix_connect  
	(int sockfd, char *name);

int tcpip_unix_bind	
	(int sockfd, char *name);

   /* turn on asynchronous I/O */

int tcpip_asynchronous 
	(int sockfd);

   /* accept and listen */

int tcpip_accept
	(int sockfd);

int tcpip_listen
	(int sockfd);

   /* get the name of the current host                        */
   /* get the IP number of the given host                     */
   /* get the IP address and port number attached to a socket */

char *tcpip_hostname (void);
int   tcpip_getip (char *machine, UINT_32 *ip);
int   tcpip_getsockname (int sockfd, UINT_32 *ip, UINT_32 *port);
int   tcpip_getpeername (int sockfd, UINT_32 *ip, UINT_32 *port);
  
   /* read and write n bytes */

int tcpip_readn  (register int fd, register char *ptr, register size_t nbytes);
int tcpip_writen (register int fd, register char *ptr, register size_t nybtes);

   /* read and write bytes, shorts, longs and strings */

int   tcpip_read_byte    (int fd, UINT_8  *number);
int   tcpip_read_short   (int fd, UINT_16 *number);
int   tcpip_read_long    (int fd, UINT_32 *number);    
char *tcpip_read_string  (int fd);
int   tcpip_write_byte   (int fd, UINT_8   number);
int   tcpip_write_short  (int fd, UINT_16  number);
int   tcpip_write_long   (int fd, UINT_32  number);
int   tcpip_write_string (int fd, char *string);

   /* convert an error code to a string */

const char *tcpip_error_to_string (int code);

#endif
