/* Agent Tcl
   Bob Gray
   28 Spetember 1995

   timers.h

   This file defines a class that allows a process to define any number of
   timers.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TIMERS_H
#define _TIMERS_H

#include <sys/types.h>
#include <sys/times.h>

  /* client data */

typedef void *TimerClientData;

  /* default size of the timer heap */

const DEFAULT_TIMER_MAX = 8;

  /* interrupt handler for SIGALRM */

void sigalrm_handler (int signo);

  /* one TIMER */
 
struct TIMER
{
  clock_t interval;          /* timer interval (ticks)                       */
  clock_t stop;              /* timer expiration (ticks)                     */
  void (*function) (TIMER);
  TimerClientData data;   /* client data to pass to the function          */

    /* constructors */

  TIMER (void);
  TIMER (const TIMER &timer);
  TIMER (clock_t interval, void (*function) (TIMER), TimerClientData data);

    /* assignment operator */ 

  TIMER &operator= (TIMER &timer);
};

  /* function that is called when the timer fires */

typedef void (*TimerFunc) (TIMER);

  /* all active TIMERS */

class TIMERS
{
      /* sigalrm_handler can access any element of the class */

    friend void sigalrm_handler (int);

    static int count;         /* number of instances of this class    */
    static long ticks;        /* number of clock ticks per second     */
    static int timerMax;      /* maxium number of timers in the heap  */
    static int timerCount;    /* number of timers in the heap         */
    static TIMER *timerHeap;  /* a min-heap of timers                 */

      /* swap two elements of the heap */

    static void swap (int i, int j);

      /* bubble an element up */

    static void bubble_up (int i);

      /* dispose of expired timers */

    static void disposeTimers (void);

      /* remove a timer */

    static void remove (TIMER &timer);

  public:

      /* fill in a timeval structure with the time until a clock_t walltime */

    static struct timeval * ticksToTimeval 
	(clock_t wall, struct timeval &duration);
  
      /* get the number of ticks per second */
 
    static clock_t getTicks (void);

      /* get the current wall time in clock ticks */

    static clock_t getWall (void);

      /* insert a timer */

    void add (TIMER timer);
 
      /* constructor and destructor */

    TIMERS (void);
   ~TIMERS ();
};

#endif
