/* Agent Tcl
   Bob Gray
   11 July 1995

   transmit.h

   This file defines the routines that send and receive messages.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TRANSMIT_H
#define _TRANSMIT_H

#include "message.h"

const MESSAGE_TIMEOUT = -1;
const MESSAGE_ERROR   = -2;
const MESSAGE_FILE    = -3;

int message_conn
	(char *server, UINT_32 server_ip, clock_t stop, int async);
 
int message_send 
	(int sockfd, MESSAGE &message);

MESSAGE *message_receive 
	(int sockfd, const MESSAGE_SET &set);

int message_conn_and_send 
	(char *server, UINT_32 server_ip, MESSAGE &message, clock_t stop,
	int async);

#endif 
