/* Agent Tcl
   Bob Gray
   10 January 1996

   tclAgent.h

   This file redefines class AGENTS for use in the Tcl/Tk interpreters.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_AGENT_H
#define _TCL_AGENT_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _GEN_AGENT_H 
#include "genAgent.h"
#endif
#ifndef _SUPP_DBUFFER_H
#include "suppDBuffer.h"		// DynamicBuffer
#endif
#ifndef _GEN_SERVER_FLAGS
#include "genServerInterface.h"	// ServerInterface::SubmissionTypes
#endif
#ifndef _TCL_MAP_H
#include "tclMap.h"
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"
#endif

struct Tcl_Interp;
class DynamicBuffer;
class Version;

class IncomingCallback_TCL: public IncomingCallback
{
    friend class AGENT_TCL;

    friend int agentAsyncIncoming
	(ClientData clientData, Tcl_Interp *interp, int code);

	/* asynchronous Tcl handler for incoming communication */

    Tcl_AsyncHandler incomingAsync;

private:

	/* constructor and destructor */

    IncomingCallback_TCL (void);
    virtual ~IncomingCallback_TCL ();

	/* callback when there might be an incoming item */

    void incomingAlarm (void) {
	Tcl_AsyncMark (incomingAsync);
    }
};

class AGENT_TCL: public AGENT 
{
	/* map Tcl_Interp structures to AGENT_TCL structures */

    static POINTER_MAP *interpMap;

	/* callback for SIGIO interrupts */

    static IncomingCallback_TCL *incomingCallback;        

	/* interpreter associated with this instance and its master */

    Tcl_Interp *interp;
    Tcl_Interp *masterInterp;

	/* program text of the agent */

    DynamicBuffer m_state;
    ServerInterface::SubmissionTypes m_type;

	/* capture the current state of the interpreter */

    int captureState 
	(JumpType jumpType, DynamicBuffer& stateBuffer);

	/* restore the current state of the interpreter */

    int restoreState
	(ServerInterface::SubmissionTypes type, const DynamicBuffer& buffer);

	/* set the Tcl interpreter */

    int setupInterps (void);

public:

	/* constructor when restoring an agent */

    AGENT_TCL (const Version &version);

	/* constructor when creating a new agent */

    AGENT_TCL (Tcl_Interp *interp, Tcl_Interp *masterInterp, const Version &version);

	/* run an agent */

    int agentRun (void);

	/* return the Tcl_Interp associated with this AGENT_TCL instance */

    Tcl_Interp *getInterpreter (void) {
	return (interp);
    }

    Tcl_Interp *getMasterInterpreter (void) {
	return (masterInterp);
    } 

	/* return the AGENT_TCL instance associated with a Tcl_Interp */

    static AGENT_TCL *get_agent (Tcl_Interp *interp) {

	AGENT_TCL *agent;

	if (interpMap == NULL) {
	    agent = NULL;
	} else {
	    agent = interpMap -> lookup (interp);
        }

	return (agent); 
    };

	/* destructor */

   ~AGENT_TCL (void);
};

#endif    /* TCL_AGENT */
