/* Agent Tcl
   Bob Gray
   17 December 1997

   tclFactory.h

   This file defines a factory class that will create the appropriate
   SECURITY, RESTRICT, LOCATION, AgentMasks and AgentMeeting instace.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "tclFactory.h"
#include "tclLocation.h"
#include "tclMasks.h"
#include "tclMeeting.h"
#include "tclRestrict.h"
#include "tclSecurity.h"

SECURITY *AgentFactory_Tcl::createSecurityInstance (AGENT *agent) const
{
    return (new SECURITY_TCL ((AGENT_TCL *) agent));
}

RESTRICT *AgentFactory_Tcl::createRestrictInstance (AGENT *agent) const
{
    return (new RESTRICT_TCL ((AGENT_TCL *) agent));
}

LOCATION *AgentFactory_Tcl::createLocationInstance (AGENT *agent) const
{
    return (new LOCATION_TCL ((AGENT_TCL *) agent));
}


AgentMasks *AgentFactory_Tcl::createMasksInstance (AGENT *agent) const
{
    return (new MASKS_TCL ((AGENT_TCL *) agent));
}

AgentMeetings *AgentFactory_Tcl::createMeetingsInstance (AGENT *agent) const
{
    return (new MEETINGS_TCL ((AGENT_TCL *) agent));
}
