/* Agent Tcl
   Bob Gray
   17 December 1997

   tclFactory.h

   This file defines a factory class that will create the appropriate
   SECURITY, RESTRICT, LOCATION, AgentMasks and AgentMeeting instace.
*/

#ifndef _TCL_FACTORY_H
#define _TCL_FACTORY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _GEN_FACTORY_H
#include "genFactory.h"		// AgentFactory
#endif

class AGENT;
class AgentMasks;
class AgentMeetings;
class LOCATION;
class RESTRICT;
class SECURITY;

class AgentFactory_Tcl: public AgentFactory
{
    public:

	    /*
	     * subsystems
	     */

	virtual SECURITY      *createSecurityInstance (AGENT *agent) const;
	virtual RESTRICT      *createRestrictInstance (AGENT *agent) const;
	virtual LOCATION      *createLocationInstance (AGENT *agent) const;
	virtual AgentMasks    *createMasksInstance    (AGENT *agent) const;
	virtual AgentMeetings *createMeetingsInstance (AGENT *agent) const;
};

#endif
