/* Agent Tcl
   Bob Gray
   10 January 1996

   tclLocation.h

   This file redefines class LOCATION for use in the Tcl/Tk interpreters.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_LOCATION_H
#define _TCL_LOCATION_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

    /* forward declarations */

class AgentId;

#include "tcl.h"
#include "tclAgent.h"
#include "genLocation.h"

class LOCATION_TCL: public LOCATION
{
    friend class AGENT_TCL;
    friend class AgentFactory_Tcl;

	/* interpreter associated with this instance */

    Tcl_Interp *interp;
    Tcl_Interp *masterInterp;

	/* TRUE if modification of the "agent" array is allowed */

    int modified;

	/* reload an element of "agent" array */

    void refreshVariableString 
	(char *name, char *string);

#ifdef TCL8
    void refreshVariableObj
	(char *name, Tcl_Obj *valueObject);
#endif

	/* reload the version section of the "agent" array */

    void refresh_version (void);

	/* set the Tcl interpreter */

    void setInterp (Tcl_Interp *interp, Tcl_Interp *masterInterp);

	/* constructor and destructor */

    LOCATION_TCL (AGENT_TCL *agent);
   ~LOCATION_TCL ();

	/* change notification from the core class */

    void changeNotification (void);

public:

	/* return the modified flag */

    inline int allowModification (void) { return modified; };

	/* reload the "agent" array */

    void refresh (void);

};

#endif
