/* Agent Tcl
   Bob Gray
   10 January 1996

   tclMakeLists.h

   This file defines various conversion routines.

   Copyright (c) 1995-1999, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_MAKE_LISTS_H
#define _TCL_MAKE_LISTS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifdef __cplusplus
#define EXTERNAL extern "C"
#else
#define EXTERNAL extern
#endif

struct AgentId;
struct Tcl_DString;
struct Tcl_Obj;
struct BASE_SECURITY;

    /*
     * convert an AgentId instance into either a string-based list or
     * an object-based list
     */

EXTERNAL void Agent_IdToTclList
	(AgentId *agentId, Tcl_DString *dstring);

#ifdef TCL8

EXTERNAL Tcl_Obj *Agent_IdToTclListObj
	(AgentId *agentId);

#endif


    /*
     * convert a BASE_SECURITY instance into either a string-based list or
     * an object-based list
     */

EXTERNAL void Agent_SecurityToTclList
	(BASE_SECURITY *security, Tcl_DString *dstring);

#ifdef TCL8

EXTERNAL Tcl_Obj *Agent_SecurityToTclListObj
	(BASE_SECURITY *security);

#endif
#endif
