/* Agent Tcl
   Bob Gray
   4 September 1995

   map.h

   This file defines the class which associates pointers with related pointers.
*/

#ifndef _MAP_H
#define _MAP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include <stdlib.h>
#include "tcl.h"

class AGENT_TCL;

class POINTER_MAP
{
	/* hash table keyed on addresses */

    Tcl_HashTable table;     

	/* result of the most recent lookup */

    Tcl_Interp *interpPtr;
    AGENT_TCL  *agentPtr;

public:

	/* add, lookup and remove */

    void add (Tcl_Interp *ptr1, AGENT_TCL *ptr2) {

	int dummy;
	Tcl_HashEntry *entry;

	    /* create the entry in the hash table */

	entry = Tcl_CreateHashEntry (&table, (char *) ptr1, &dummy);
	Tcl_SetHashValue (entry, (ClientData) ptr2);

	    /* set most recent lookup */

	interpPtr = ptr1;
	agentPtr  = ptr2;
    } 

    AGENT_TCL *lookup (Tcl_Interp *ptr) {

	AGENT_TCL *mappedPtr;
	Tcl_HashEntry *entry;

	if (ptr == interpPtr) {
	    mappedPtr = agentPtr;
	} else if ((entry = Tcl_FindHashEntry (&table, (char *) ptr)) == NULL) {
	    mappedPtr = (AGENT_TCL *) NULL;
	} else {
	    mappedPtr = (AGENT_TCL *) Tcl_GetHashValue (entry);
	    interpPtr = ptr;
	    agentPtr  = mappedPtr;
        }

	return (mappedPtr);
    }
 
    void remove (Tcl_Interp *ptr) {

	Tcl_HashEntry *entry;

            /* delete the entry if it exists */

	if ((entry = Tcl_FindHashEntry (&table, (char *) ptr)) == NULL) {
	    Tcl_DeleteHashEntry (entry);
	}

	if (interpPtr == ptr) {
	    interpPtr = (Tcl_Interp *) NULL;
	    agentPtr  = (AGENT_TCL *) NULL;
	}
    } 

	/* construcor and destructor */

    POINTER_MAP (void):
	interpPtr ((Tcl_Interp *) NULL),
	agentPtr  ((AGENT_TCL *) NULL)
    {
	Tcl_InitHashTable (&table, TCL_ONE_WORD_KEYS);
    } 

   ~POINTER_MAP () {
	Tcl_DeleteHashTable (&table);
    }
};

#endif
