/* Agent Tcl
   Bob Gray
   10 January 1996

   tclMasks.h

   This file specializes class AgentMasks for the Tcl/Tk interpreters.

   Revision information:

   $Id: tclMasks.h,v 1.9 1997/12/18 15:46:02 rgray Exp $

   $Log: tclMasks.h,v $
   Revision 1.9  1997/12/18 15:46:02  rgray
   array of current restrictions now expands as needed
   Thu Dec 18 15:46:02 GMT 1997

   Revision 1.8  1997/12/17 18:42:32  rgray
   added AgentFactory (but it's not yet complete)
   Wed Dec 17 18:42:32 GMT 1997

   Revision 1.7  1997/12/09 10:02:24  rgray
   code cleanup
   Tue Dec  9 10:02:24 GMT 1997

   Revision 1.6  1997/12/06 14:36:24  rgray
   meetingNotifierSetup and meetingNotifierCheck added
   Sat Dec  6 14:36:24 GMT 1997

   Revision 1.5  1997/11/08 17:30:06  rgray
   got things ready for the new Scheme
   Sat Nov  8 12:30:06 EST 1997

   Revision 1.4  1997/11/08 03:08:05  rgray
   moved mask capturing into the core
   Fri Nov  7 22:08:05 EST 1997

   Revision 1.3  1997/11/04 23:10:17  rgray
   halfway done moving mask packing and unpacking into the core
   Tue Nov  4 18:10:17 EST 1997

   Revision 1.2  1997/10/30 14:20:33  rgray
   renamed class MASKS as class AgentMasks (in a continuing effort to get back to a consistent naming scheme)
   Thu Oct 30 09:20:33 EST 1997


   Copyright (c) 1995-1998, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_MASKS_H
#define _TCL_MASKS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include "tclAgent.h"
#include "genMasks.h"

    /* name of an event handler */
 
class MASK_HANDLER_TCL: public AgentMaskHandler
{
  	/* name of the handler */

    DynamicString name;

public:

	/* get the handler name */

    DynamicString copy_name (void) const {
	return (name);
    }

	/* compare one handler to another */

    int compare (const AgentMaskHandler &handler) const;
 
	/* clone the handler */

    AgentMaskHandler *clone (void) const;

	/* pack and unpack the handler */

    UINT_32 getPackedSize (void) const;
    char *pack (char *bp) const;
    char *unpack (char *bp, char *end_bp);

	/* string representation */

    DynamicString getStringRepresentation (void) const;

	/* constructor and destructor */

    MASK_HANDLER_TCL (AgentMaskHandler::HandlerTypes type);
    MASK_HANDLER_TCL (AgentMaskHandler::HandlerTypes type, DynamicString name);
    virtual ~MASK_HANDLER_TCL ();
};

    /* all the masks */

class MASKS_TCL: public AgentMasks
{
    friend class AGENT_TCL;
    friend class AgentFactory_Tcl;

    friend char *maskTrace 
	(ClientData data, Tcl_Interp *interp, char *name1, char *name2, int flags);

    friend void maskEventHandler
	(ClientData clientData);

    friend int maskAsyncHandler
	(ClientData clientData, Tcl_Interp *interp, int code);

	/* interpreter associated with this instance and its master */

    Tcl_Interp *interp;
    Tcl_Interp *masterInterp;

	/* refresh the contents of the "mask" array */

    void refresh (void);

	/* TRUE if the "mask" array can be modified */

    int modified;

	/* asynchronous Tcl handlers for events */

    Tcl_AsyncHandler handlerAsync;  
	
    void event (void) {
	Tcl_AsyncMark (handlerAsync);
    }

	/* factory method to create an empty AgentMaskHandler instance */

    AgentMaskHandler *createEmptyHandler (AgentMaskHandler::HandlerTypes type) {
	AgentMaskHandler *handler = new MASK_HANDLER_TCL (type);
	return (handler);
    }

	/* call the broken connection handler */

    void callTclBroken (void);

	/* call a specific interrupt or event handler */

    void callTclHandler (EventData *event);
    
	/* call the Tcl interrupt or event handlers */

    void callTclInterrupts (void);
    void callTclEvents (void);

	/* set up the Tcl interpreter */

    void setInterp (Tcl_Interp *interp, Tcl_Interp *masterInterp);

	/* constructor and destructor */
 
    MASKS_TCL (AGENT_TCL *agent);
   ~MASKS_TCL ();

public:

	/* change one of the three distinguished masks */

    int updateHandle (int which, UINT_32 handle);
};

#endif    /* _TCL_MASKS_H */
