/* Agent Tcl
   Bob Gray
   15 June 1996

   tclMeeting.h

   This file specializes class MEETINGS for the Tcl/Tk interpreters.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_MEETINGS_H
#define _TCL_MEETINGS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

class AGENT_TCL;

#ifndef _INCLUDE_TCL_H
#define _INCLUDE_TCL_H
#include "tcl.h"		// Tcl_AsyncMark
#endif
#ifndef _GEN_MEETING_H
#include "genMeeting.h"		// Meetings
#endif

    /* the meetings */

class MEETINGS_TCL: public AgentMeetings
{
    friend class AGENT_TCL;
    friend class AgentFactory_Tcl;

	/* e_TRUE if modification of meeting array is allowed */

    BOOLEAN modified;
 
	/* interpreter associated with this instance and its master */

    Tcl_Interp *interp;
    Tcl_Interp *masterInterp;

	/* set the Tcl interpreter */

    void setInterp (Tcl_Interp *interp, Tcl_Interp *masterInterp);

	/* new handle or removed handle */

    void new_handle (UINT_32 handle);
    void remove_handle (UINT_32 handle);
 
	/* set or unset one entry in the array */

    void set_string (char *name);
    void unset_string (char *name);

	/* constructor and destructor */
 
    MEETINGS_TCL (AGENT_TCL *agent);
   ~MEETINGS_TCL ();

public:

	/* get the associated interpreter */

    Tcl_Interp *get_interp (void) {
	return (interp);
    };

	/* returns e_TRUE if modification of the restrict array is allowed */

    BOOLEAN allowModification (void) {
	return (modified);
    }; 

	/* refresh the elements of the "restrict" array */

    void refresh (void);
};

#endif  /* _TCL_MEETINGS_H */
