/* Agent Tcl
   Bob Gray
   10 January 1996

   tclRestrict.h

   This file redefines class RESTRICT for use in the Tcl/Tk interpreters.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_RESTRICT_H
#define _TCL_RESTRICT_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include "tcl.h"
#include "tclAgent.h"
#include "genRestrict.h"
#include "platTimers.h"

    /* forward declaration so we can compile */ 

class Permit;

  /* Tcl-specific restrictions */

class RESTRICT_TCL: public RESTRICT
{
    friend class AGENT_TCL;
    friend class AgentFactory_Tcl;

	/* interpreter associated with this instance and its master */

    Tcl_Interp *m_interp;
    Tcl_Interp *m_masterInterp;

	/* Tcl asynchonous handler that is called on potential permit violations */

    Tcl_AsyncHandler m_handler;
    BOOLEAN m_pendingAlarm;

	/* e_TRUE if modification of restrict array is allowed */

    BOOLEAN m_modified;
 
	/* set the interpreter */

    void setInterp (Tcl_Interp *interp, Tcl_Interp *masterInterp);

	/* set or unset the information for one level in the array */

    void set_level (void);
    void unset_level (void);

	/* set or unset one entry in the array */

    void set_string (char *name);
    void unset_string (char *name);

	/* callback when there is a potential user-defined permit violation */

    void pendingPermitViolation (void);

 	/* constructor and destructor */

    RESTRICT_TCL (AGENT_TCL *agent);
   ~RESTRICT_TCL ();

public:

	/* get the associated interpreters */

    Tcl_Interp *get_interp (void) const {
	return (m_interp);
    } 

    Tcl_Interp *get_master_interp (void) const {
	return (m_masterInterp);
    }

	/* returns e_TRUE if modification of the restrict array is allowed */

    BOOLEAN allowModification (void) {
	return (m_modified);
    }  

	/* refresh the elements of the "restrict" array */

    void refresh (void);

	/* add a new user-specified permit */

    void addUserPermit (Permit &permit) {
	RESTRICT::addUserPermit (permit);
	set_level ();
    }

	/* remove a user-specified permit */

    void removeUserPermit (void) {
	RESTRICT::removeUserPermit ();
	unset_level ();
    }

	/* set the result code for the interpreter and all its slaves */

    void setAllResultCodes (int code);
};

#endif
