/* Agent Tcl
   Bob Gray
   17 April 1996

   tclSecurity.h

   This file redefines class SECURITY for use in the Tcl/Tk interpreters.
 
   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_SECURITY_H
#define _TCL_SECURITY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _GEN_SECURITY_H
#include "genSecurity.h" 	// SECURITY
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

class AgentId;
struct Tcl_Interp;

class SECURITY_TCL: public SECURITY
{
    friend class AGENT_TCL;
    friend class AgentFactory_Tcl;

	/* interpreters associated with this instance */

    Tcl_Interp *interp;
    Tcl_Interp *masterInterp;

	/* TRUE if modification of the "security" array is allowed */

    BOOLEAN modified;

	/* reload a BOOLEAN element of the security array */

    void refresh_boolean (char *name, BOOLEAN value, BOOL_FORMAT format);

	/* reload a string element of the security array */

    void refresh_string (char *name, char *string);

	/* set the Tcl interpreter */

    void setInterp (Tcl_Interp *interp, Tcl_Interp *masterInterp);

	/* record or throw away the server's keyname */

    void recordServerKeyname (const AgentId &id); 
    void throwServerKeyname (void);

	/* constructor and destructor */

    SECURITY_TCL (AGENT_TCL *agent);
   ~SECURITY_TCL ();

public:

	/* return the modification flag */

    BOOLEAN allowModification (void) {
	return (modified);
    } 

	/* reload the security array */

    void refresh (void);

	/* turn on or off encryption */

    int setEncryption (BOOLEAN state) {

	int code;

	if ((code = SECURITY::setEncryption (state)) == SECURITY_OK) {
	    refresh_boolean ("encryption", state, e_ON_OFF);
	}

	return (code);
    } 

	/* turn on or off signatures */

    int setSignatures (BOOLEAN state) {

	int code;

	if ((code = SECURITY::setSignatures (state)) == SECURITY_OK) {
	    refresh_boolean ("signatures", state, e_ON_OFF);
	}

	return (code);
    }  
};

#endif
