/* Agent Tcl
   Bob Gray
   10 January 1996

   tclUtility.h

   This file defines various utility routines.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_UTILITY_H
#define _TCL_UTILITY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifdef __cplusplus
#define EXTERNAL extern "C"
#else
#define EXTERNAL extern
#endif

struct Tcl_Interp;
struct Tcl_DString;

/*
 * transfer a result string from one interpreter to another
 */

EXTERNAL void Tcl_TransferResult (Tcl_Interp *dest, Tcl_Interp *source); 

/*
 * extract the contents of a Tcl_DString
 */

EXTERNAL char *Tcl_DStringExtract (Tcl_DString *dstring);

#endif
