/* Agent Tcl
   Bob Gray
   1 September 1995

   queue.h

   This file defines a FIFO or queue for DynamicString's.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _SUPP_DSTRING_QUEUE_H
#define _SUPP_DSTRING_QUEUE_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _SUPP_DSTRING_H
#include "suppDString.h"		// DynamicString
#endif

    /* FIFO or queue */

class DynamicStringQueue
{
    enum QueueSizing { 
	e_QUEUE_EXPAND, 
	e_QUEUE_SHRINK 
    };

    DynamicString *elements;  /* elements                                      */
    int count;                /* number of elements in the queue               */   
    int slots;                /* number of slots in the queue                  */
    int shrink_count;         /* number of elements at which queue is halved   */ 
    int expand_count;         /* number of elements at which queue is expanded */ 
    int head;                 /* head of the queue (an index into "elements")  */
    int tail;                 /* tail of the queue (an index into "elements")  */

	/* resize the queue */

    void resize_queue (QueueSizing which);

public:

	/* get the number of items in the queue */

    int get_count (void) const {
      return (count);
    }

	/* constructor and destructor */

    DynamicStringQueue (void);
    DynamicStringQueue (const DynamicStringQueue &queue);
   ~DynamicStringQueue ();

	/* assignment operator */

    DynamicStringQueue &operator= (const DynamicStringQueue &queue);

	/* push, enqueue and dequeue */

    void push (DynamicString item);
    void enqueue (DynamicString item);
    DynamicString dequeue (void);

	/* peek at queue element i */

    DynamicString peek (int i) const;
};

#endif     
