/* Agent Tcl
   Bob Gray
   19 April 1997

   genEncrypt.h

   This file defines the "meta-messages" that are used to pass around encrypted 
   and digitially-signed messages.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_ENCRYPT
#define _GEN_ENCRYPT

#ifndef NO_PRAGMAS
#pragma interface
#endif

    /* forward declarations */

class MachineId;
class MESSAGE;
class BASE_SECURITY;

#include "genMessage.h"

    /* message flags */ 

const UINT_8 PROT_BOTH		= 0;
const UINT_8 PROT_SIGNED	= 1;
const UINT_8 PROT_ENCRYPTED	= 2;
const UINT_8 PROT_NONE		= 3;
const UINT_8 PROT_KEY		= 4;
const int    NUM_PROT           = 5;

    /* set of encryption messages */

extern MESSAGE_SET protectionMessages;

    /* unsecure an incoming message */

int unsecure 
	(const MESSAGE_SET &set, const BASE_SECURITY &receiver, 
	 MESSAGE &message, BASE_SECURITY &sender, 
	 MESSAGE *&unsecuredMessage);
 
    /* secure a message for transmission to the server */

int secureForServer
	(const MachineId &machine, const BASE_SECURITY &security, 
	 MESSAGE &message, MESSAGE *&securedMessage);

    /* construct the keyname associated with a server */

char *makeServerKeyname 
	(const MachineId &machine);

char *makeFullServerKeyname
	(const MachineId &machine);

    /* get the text associated with the last encryption error */

DynamicString getEncryptionError
	(void);

#endif
