/* Agent Tcl
   Bob Gray
   22 February 1995

   genError.h

   This file defines class ERROR which provides an error logging facility. 
   ERROR is based on the error logged facilities in "UNIX Network Programming"
   by W. Richard Stevens [Prentice-Hall, 1990].
   
   Copyright 1995, Robert S. Gray, Department of Computer Science, Dartmouth
*/

#ifndef _GEN_ERROR_H
#define _GEN_ERROR_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include "truefalse.h"

class ERROR
{
    int count;		// lock count
    BOOLEAN useStderr;  // e_TRUE if error message should be sent to stderr 
    int logfd;          // file descriptor for the log file                
    char *logname;      // path name of the log file                      

      /* open and close the error log */

    int openLog   (void);
    void closeLog (void);
 
  public:

      /* constructor and destructor */

    ERROR (const ERROR& errorLog);
    ERROR (char *logname);
    ERROR (void);
   ~ERROR (); 

      /* assignment operator */

    ERROR& operator= (const ERROR& errorLog);

      /* log the date */

    void error_date (void);

      /* log error messages */

    void error_sys_cont (char *message);
    void error_sys_quit (char *message);
    void error_app_cont (char *message);
    void error_app_quit (char *message);

      /* log a multi-part error message */

    void error_sys_cont (char **argv);
    void error_sys_quit (char **argv);
    void error_app_cont (char **argv);
    void error_app_quit (char **argv);
};

#endif
