/* Agent Tcl
   Bob Gray
   17 December 1997

   genFactory.h

   This file defines a factory class that will create the appropriate
   SECURITY, RESTRICT, LOCATION, AgentMasks and AgentMeeting instace.
*/

#ifndef _GEN_FACTORY_H
#define _GEN_FACTORY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

class AGENT;
class AgentMasks;
class AgentMeetings;
class LOCATION;
class RESTRICT;
class SECURITY;

class AgentFactory 
{
    public:

	    /*
	     * subsystems
	     */

	virtual SECURITY      *createSecurityInstance (AGENT *agent) const = 0;
	virtual RESTRICT      *createRestrictInstance (AGENT *agent) const = 0;
	virtual LOCATION      *createLocationInstance (AGENT *agent) const = 0;
	virtual AgentMasks    *createMasksInstance    (AGENT *agent) const = 0;
	virtual AgentMeetings *createMeetingsInstance (AGENT *agent) const = 0;
};

#endif
