/* Bob Gray
   Agent Tcl
   16 June 1996

   genManagers.h

   These routines define "Smart Pointers" that handle automatic deletion
   and reference counting.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_MANAGERS_H
#define _GEN_MANAGERS_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include "platPorting.h"
#include "agentId.h"
#include "genUtility.h"
#include "genRestrict.h"
#include "platTimers.h"

#ifndef _PLAT_DELETE_H
#include "platDelete.h"
#endif

/*
 * forward declarations
 */

class AgentId;
class Permit;
 

class RestrictMgr
{
    RESTRICT &restrict;

    RestrictMgr& operator= (const RestrictMgr&);  // no assignment
 
public:

    RestrictMgr (RESTRICT &p_restrict, Permit &permit, TimerTrap *trap):
	restrict (p_restrict)
    {
	restrict.addPermit (permit, trap);
    }

   ~RestrictMgr () {
	restrict.removePermit ();
    }
};

class SmartCharPtr 
{
	char *ptr;
	SmartCharPtr (const SmartCharPtr&); 	        // unimplemented
	SmartCharPtr& operator= (const SmartCharPtr&);  // unimplemented

    public:

	    /* deallocate or relingquish ownership */

	void deallocate (void) {
	    DELETE_ARRAY_OBJECT(ptr);
	}

	char *relinquishOwnership (void) {
	    char *old = ptr;
	    ptr = (char *) NULL;
	    return (old);
	}

	    /* constructor, destructor and assignment operator */

	SmartCharPtr (char *p_ptr = NULL):
	    ptr (p_ptr)
	{
	    /* empty */
	}

       ~SmartCharPtr () {
	    deallocate ();
	}

	SmartCharPtr& operator= (char * p_ptr) {
	    deallocate ();
	    ptr = p_ptr;
	    return (*this);
	}

	    /* comparison */

	int operator== (char *string) {
	    return (ptr == string);
	}

	    /* access and type conversion */

/*
	char* operator-> (void) {
	    return (ptr);
	}
*/

	char& operator* (void) {
	    return (*ptr);
	}

	operator char* () {
	    return (ptr);
	}
};

class SmartIdPtr 
{
	AgentId *ptr;
	SmartIdPtr (const SmartIdPtr&); 	    // unimplemented
	SmartIdPtr& operator= (const SmartIdPtr&);  // unimplemented

    public:

	    /* deallocate or relingquish ownership */

	void deallocate (void) {
	    DELETE_OBJECT(ptr);
	}

	AgentId *relinquishOwnership (void) {
	    AgentId *old = ptr;
	    ptr = (AgentId *) NULL;
	    return (old);
	}

	    /* constructor, destructor and assignment operator */

	SmartIdPtr (AgentId *p_ptr = NULL):
	    ptr (p_ptr)
	{
	    /* empty */
	}

       ~SmartIdPtr () {
	    deallocate ();
	}

	SmartIdPtr& operator= (AgentId * p_ptr) {
	    deallocate ();
	    ptr = p_ptr;
	    return (*this);
	}

	    /* access and type conversion */

	AgentId* operator-> (void) {
	    return (ptr);
	}

	AgentId& operator* (void) {
	    return (*ptr);
	}

	operator AgentId* () {
	    return (ptr);
	}
};

class SmartFilePtr
{

	FILE *fp;
	SmartFilePtr (const SmartFilePtr&); 	        // unimplemented
	SmartFilePtr& operator= (const SmartFilePtr&);  // unimplemented

    public:

	    /* deallocate or relinquish ownership */

	void deallocate (void) {
	    
	    if (fp != NULL) {
		fclose (fp);
	    }

	    fp = NULL;
	}

	FILE *relinquishOwnership (void) {
	    FILE *old = fp;
	    fp = NULL;
	    return (old);
	}

	    /* constructor, destructor and assignment operator */

	SmartFilePtr (FILE *p_fp = NULL):
	    fp (p_fp)
	{
	    /* empty */
	}

       ~SmartFilePtr () {
	    deallocate ();
	}

	SmartFilePtr& operator= (FILE * p_fp) {
	    deallocate ();
	    fp = p_fp;
	    return (*this);
	}

	    /* access and type conversion */

	FILE* operator-> (void) {
	    return (fp);
	}

	FILE& operator* (void) {
	    return (*fp);
	}

	operator FILE* () {
	    return (fp);
	}
};

#endif  /* GEN_MANAGERS_H */
