/* Agent Tcl
   Bob Gray
   27 July 1998

   genMesgDriver.h

   This file defines the MessageDriver class, which provides routines for
   sending and receiving messages across a connection.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_MESG_DRIVER
#define _GEN_MESG_DRIVER

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#ifndef _MESG_CONNECTION_H
#include "mesgConnection.h"	// Connection::ConnectionErrors
#endif

struct timeval;
class BASE_SECURITY;
class DynamicBuffer;
class MachineId;
class MESSAGE;
class MESSAGE_SET;

class MessageDriver
{
public:

	// convert a Connection::ConnectionErrors code into a message code

    static int connectionCodeToMessageCode
	(Connection::ConnectionErrors code);

	// send a signed and/or encrypted message

    static int secureSend
	(Connection &connection,
	 const MachineId &machine, 
	 const BASE_SECURITY &security,
	 MESSAGE &message,
	 struct timeval *stop = NULL);

	// send an unsigned, unencrypted message

    static int unsecureSend
	(Connection &connection,
	 MESSAGE &message,
	 struct timeval *stop = NULL);

	// send the contents of a buffer

    static int sendFromBuffer
	(Connection &connection,
	 DynamicBuffer &buffer);

	// receive an unsigned, unencrypted message

    static int unsecureReceive
	(MESSAGE *&receivedMessage,
	 Connection &connection,
	 const MESSAGE_SET &messageSet,
	 struct timeval *stop = NULL);

	// receive into a buffer

    static int receiveIntoBuffer
	(Connection &connection,
	DynamicBuffer &buffer);
};

#endif
