/* Agent Tcl
   Bob Gray
   20 April 1996

   genPGP.h

   This file defines the routines that are used to access PGP.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_PGP_H
#define _GEN_PGP_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

    /* forward declarations */

class DynamicString;
class SEC_IDENTITY;

    /* get the last PGP error */

DynamicString PGP_error
	(void);

    /* set the pathname of the PGP executable and the key directory */

void PGP_setExecutablePath 
	(DynamicString path);

void PGP_setKeyDirectory
	(DynamicString path);

    /* get the extension for encrypted PGP files */

const char *PGP_extension 
	(void);

    /* sign, encrypt, encrypt and sign and decrypt a file */

int PGP_Sign
	(char *plaintextFilename, char *encryptedFilename, 
	 SEC_IDENTITY &sender);

int PGP_Encrypt
	(char *plaintextFilename, char *encryptedFilename, 
	 char *recipientKey);

int PGP_EncryptAndSign 
	(char *plaintextFilename, char *encryptedFilename, 
	 char *recipientKey, SEC_IDENTITY &sender);

int PGP_Decrypt
	(char *plaintextFilename, char *encryptedFilename, 
	 SEC_IDENTITY &receiver);

char *PGP_DecryptSigned
	(char *plaintextFilename, char *encryptedFilename, 
	 SEC_IDENTITY &receiver);
	
#endif /* _GEN_PGP_H */
