/* Agent Tcl
   Bob Gray
   1 July 1995

   genPipe.cc   

   This file implements the routines that create pipes.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "suppFileTable.h"
#include "genPipe.h"

/* PipeUtility::createStreamPipe

   Purpose: Create a stream pipe

     Input: None

    Output: The procedure returns e_UNKNOWN on error.  Otherwise the procedure
            sets fd[0] to one end of the stream pipe, sets fd[1] to the
            other end of the stream pipe and returns e_OK.
*/

PipeUtility::PipeError PipeUtility::createStreamPipe (int *fd)
{
    PipeError rc;

	// create the pipe endpoints

    if (socketpair (AF_UNIX, SOCK_STREAM, 0, fd) < 0) {

	rc = e_UNKNOWN;

    } else {

	    // add the pipe endpoints to the file descriptor table
	
	if (FileTable::isFileRecordingOn()) {
	    FileTable::add (fd[0], FileTable::e_PIPE);
	    FileTable::add (fd[1], FileTable::e_PIPE);
	}

	rc = e_OK;
    }

    return (rc);
}

/* PipeUtility::closePipe

   Purpose: Close a pipe

     Input: fd = file descriptor of the pipe
                 (int)

    Output: The procedure returns e_UNKNOWN on error.  Otherwise the
            procedure closes the pipe and returns e_OK; 
*/

PipeUtility::PipeError PipeUtility::closePipe (int fd)
{
    PipeError rc;

	// remove the pipe from the file descriptor table

    if (FileTable::isFileRecordingOn()) {
	FileTable::remove (fd);
    }

	// close the pipe

    if (close(fd) < 0) {
	rc = e_UNKNOWN;
    } else {
	rc = e_OK;
    }

    return (rc);
}
