/* Agent Tcl
   Bob Gray
   17 April 1996 
   
   genSecurity.h
  
   This file defines the data structures that keep track of the current
   security parameters.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_SECURITY_H
#define _GEN_SECURITY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _SUPP_DSTRING_H
#include "suppDString.h"		// DynamicString
#endif
#ifndef _GEN_SERVER_FLAGS_H
#include "genServerInterface.h"	// SubmissionTypes
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

#include "agentSecure.h"
#include "genUtility.h"

    /* forward declarations */

class AgentId;

    /* error codes */

const int SECURITY_BEG_GENERAL		= 0;
const int SECURITY_OK			= 0;
const int SECURITY_NOT_INITIALIZED	= 1;
const int SECURITY_NO_DIRECTORY		= 2;
const int SECURITY_NO_PASS		= 3;
const int SECURITY_NO_ID	 	= 4;
const int SECURITY_END_GENERAL		= 4;

    /* class SECURITY keeps track of the current security parameters for an agent */

class SECURITY: public BASE_SECURITY
{
    friend class AGENT;

protected:

	/* agent associated with this instance */

    AGENT *agent;

	/* directory in which the agent is looking for security information */

    char *directory;

	/* "available" is true if security features are available  */
	/* if "available" is false, then "availableCode" holds the */
	/* error code that indicates why security festures are not */
	/* available						   */

    BOOLEAN available;
    int availableCode;

	/* record or throw away the server keyname */

    virtual void recordServerKeyname (const AgentId& id);
    virtual void throwServerKeyname (void);

	/* constructor and destructor */

    SECURITY (AGENT *agent);
    virtual ~SECURITY () {};

	/* bootstrap security for an incoming agent */

    int arrivingBootstrap 
	(ServerInterface::SubmissionTypes type, const BASE_SECURITY &sender);

public:

	/* bootstrap security for an agent started on the current machine -- */
	/* this routine identifies the identity of the agent's user as well  */
	/* as the necessary encryption keys -- this is routine is somewhat   */
	/* PGP dependent					             */

    int startingBootstrap (void);

	/* turn on or off encryption or signatures */

    virtual int setEncryption (BOOLEAN p_encryption);
    virtual int setSignatures (BOOLEAN p_signatures);

	/* return whether or not security bootstrap succeded */

    BOOLEAN isSecurityAvailable (void) const {
	return (available);
    };

	/* return the code associated with security bootstrap */

    int getCode (void) const {
	return (availableCode);
    }

	/* convert a security error code into a short or long string */

    DynamicString securityCodeToShortString (int code);
    DynamicString securityCodeToLongString (int code);
};

#endif
