/* Agent Tcl
   Bob Gray
   9 December 1997

   genServerInterface.h

   This file defines the flags, exitcodes, sizes and messages that make up
   the interface between the agents and the server.
*/

#ifndef _GEN_SERVER_INTERFACE_H
#define _GEN_SERVER_INTERFACE_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_SIZES_H
#include "platSizes.h"		// UINT_32
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

class ServerInterface
{
public:

        /* 
         * incoming agent can be a new agent (e_SUB_SCRIPT), a cloned agent
 	 * (e_SUB_FORK), a regular migrating agent (e_SUB_JUMP), an agent
 	 * migrating Aglet-style (e_SUB_AGLET_JUMP), or an agent submitting
 	 * Aglet-Style (e_SUB_AGLET_SUBMIT)
	 */

    enum SubmissionTypes {
	e_SUB_SCRIPT		= 0x0,
	e_SUB_FORK		= 0x1,
	e_SUB_JUMP		= 0x2,
 	e_SUB_AGLET_JUMP	= 0x3,
 	e_SUB_AGLET_SUBMIT	= 0x4
    };

    static BOOLEAN isSubmissionTypeOutOfRange (SubmissionTypes type) {
	return ((UINT_32) type > (UINT_32) e_SUB_AGLET_SUBMIT)
	    ? e_TRUE : e_FALSE;
    }
	
	/*
	 * interpreter exit codes that have a special meaning to the server
	 */

    enum InterpreterExitcodes {
	e_GLOBAL_WALL_VIOLATION		= 64,
	e_GLOBAL_CPU_VIOLATION		= 65,
	e_GLOBAL_JUMPS_VIOLATION	= 66,
	e_GLOBAL_CHILDREN_VIOLATION	= 67,
	e_GLOBAL_DEPTH_VIOLATION	= 68,
	e_CAN_NOT_RESTORE_STATE		= 69,
	e_RECEIVED_SIGTERM		= 70
    };

	/* 
	 * server error codes:
	 * 
	 * e_SERV_ERR_UNKNOWN	      = The server failed for an unknown reason. 
	 *
	 * e_SERV_ERR_SOURCE	      = The server does not accept any requests from the
	 *			        agent's current machine -- i.e., the agent's
	 *			        current machine is not on the server's access
	 *			        list.
	 *
	 * e_SERV_ERR_INTERP	      = The necessary interpreter is not available on the
	 *			        server's machine -- i.e., the agent can not be
	 *			        executed.
	 *
	 * e_SERV_ERR_SYSTEM	      = A system error occurred at the server side.
	 *
	 * e_SERV_ERR_INVALID	      = The server does not support the agent's request.
	 *
	 * e_SERV_ERR_LOST	      = The server can not find the source agent in its 
	 *			        tables.
	 *
	 * e_SERV_ERR_NONEXISTENT       = The server can not find the target agent in its
	 *			        tables. 
	 *
	 * e_SERV_ERR_NO_EVENT          = The server can not provide an event without the 
	 *			        target agent's symbolic name. 
	 *
	 * e_SERV_ERR_NAME_USED         = The desired symbolic name is in use.
	 *
	 * e_SERV_ERR_NAME_RESERVED     = The desired symbolic name is reserved for another
	 *			        agent.
	 * 
	 * e_SERV_ERR_MAX_AGENTS        = The maximum number of agents has been reached at
	 *			        the server.
	 *
	 * e_SERV_ERR_MAX_ANON          = The maximum number of ANONYMOUS agents has been
	 *			        reached at the server.
	 *
	 * e_SERV_ERR_LIAR	      = The agent is lieing about its identity. 
	 *
	 * e_SERV_ERR_REMOTE_BEGIN      = The server does not accept registrations from
	 *			        agents on remote machines.
	 *
	 * e_SERV_ERR_ANON_REMOTE_BEGIN = The server does not accept registrations from
	 *				*anonymous* agents on remote machines.
	 *
	 * e_SERV_ERR_REMOTE_COMM	      = The server does not accept communication from
	 *				agents on remote machines.
	 *
	 * e_SERV_ERR_REMOTE_INFO	      = The server does not accept information requests
	 *				from agents on remote machines.
	 *
	 * e_SERV_ERR_ANON_REMOTE_INFO  = The server does not accept information requests
	 *				from *anonymou* agents on remote machines.
	 *
	 * e_SERV_ERR_LOAD	      = The server has reached its maximum load.
	 *
	 * e_SERV_ERR_TOO_MANY_EVENTS   = The agent has reached the maximum number of
	 *	                        pending status events.
	 *
	 * e_SERV_ERR_INVALID_FORCE     = The agent does not have sufficient authority
	 *				to force out the target agent.
	 */


    enum ServerErrorcodes {
	e_SERV_ERR_UNKNOWN	    	= 0,
	e_SERV_ERR_SOURCE	     	= 1,
	e_SERV_ERR_INTERP	     	= 2,
	e_SERV_ERR_SYSTEM	     	= 3,
	e_SERV_ERR_INVALID	     	= 4,
	e_SERV_ERR_LOST	     		= 5,
	e_SERV_ERR_NONEXISTENT    	= 6,
	e_SERV_ERR_NO_EVENT	     	= 7,
	e_SERV_ERR_NAME_USED      	= 8,
	e_SERV_ERR_NAME_RESERVED  	= 9,
	e_SERV_ERR_MAX_AGENTS     	= 10,
	e_SERV_ERR_MAX_ANON	     	= 11,
	e_SERV_ERR_LIAR	     		= 12,
	e_SERV_ERR_REMOTE_BEGIN		= 13,
	e_SERV_ERR_ANON_REMOTE_BEGIN	= 14,
	e_SERV_ERR_REMOTE_COMM      	= 15,
	e_SERV_ERR_REMOTE_INFO      	= 16,
	e_SERV_ERR_ANON_REMOTE_INFO 	= 17,
	e_SERV_ERR_LOAD			= 18,
	e_SERV_ERR_TOO_MANY_EVENTS	= 19,
	e_SERV_ERR_INVALID_FORCE	= 20 
    };
};

#endif
