/* Agent Tcl
   Bob Gray
   11 July 1995

   genTransmit.h

   This file defines the routines that send and receive messages.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_TRANSMIT_H
#define _GEN_TRANSMIT_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _SUPP_MACH_ID_H
#include "mesgMachId.h"		// MachineId
#endif

#include "agentId.h"
#include "genMessage.h"
#include "genSecurity.h"

    /* forward decalartion so we can compile */

class Connection;

    /* error codes */

const int MESSAGE_OK     	  =  0;
const int MESSAGE_TIMEOUT	  = -1;
const int MESSAGE_SYS_ERROR	  = -2;
const int MESSAGE_INVALID    	  = -3;
const int MESSAGE_ENCRYPT 	  = -4;
const int MESSAGE_DECRYPT	  = -5;
const int MESSAGE_NOT_FOUND	  = -6;
const int MESSAGE_NO_SERVER	  = -7;
const int MESSAGE_CANT_READ	  = -8;
const int MESSAGE_CANT_WRITE	  = -9;
const int MESSAGE_PENDING	  = -10;
const int MESSAGE_LOST_CONNECTION = -11;

    /* receive a message and perform any necessary descryption -- will go away soon */

int secureReceive
	(int sockfd, const MESSAGE_SET &set, const BASE_SECURITY &receiver,
	 BASE_SECURITY &sender, MESSAGE *&message);

int secureReceive_noDelayedAcknowledgement
	(int sockfd, const MESSAGE_SET &set, const BASE_SECURITY &receiver,
	 BASE_SECURITY &sender, MESSAGE *&message);

    /* basic send and receive -- building blocks for all of the above */

int message_send 
	(int sockfd, MESSAGE &message);

MESSAGE *message_receive 
	(int sockfd, const MESSAGE_SET &set);

MESSAGE *message_receive_noDelayedAcknowledgement
	(int sockfd, const MESSAGE_SET &set);

#endif 
