/* Agent Tcl
   Bob Gray
   8 September 1995

   genUtility.h

   This file defines convenience routines for freeing memory, copying memory
   blocks and working with strings.  

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_UTILITY_H
#define _GEN_UTILITY_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#include "platPorting.h"
#include "platSizes.h"

    /* two simplified, fast memcpy routines */

inline char *fast_memcpy (char *dp, const char *sp, unsigned size)
{
    memcpy (dp, sp, size);
    return (dp + size);
}

inline char *fast_src_memcpy (char *dp, char *sp, unsigned size)
{
  register unsigned i;

  for (i = 0; i < size; i++) {
    *dp++ = *sp++;
  }

  return (sp);
}

    /* convert an integer to its ASCII representation */
    /* or calculate how long the ASCII representation */
    /* of an integer will be                          */

inline void fastIntegerToAscii (int n, char *buffer) { 

    int i; 
    int digits; 

	/* count the number of digits */ 

    i = n; 
    digits = 0; 

    do 
    { 
	digits += 1; 
	i /= 10; 
    } 
    while (i > 0); 

	/* convert to a string */ 

    i = n; 
    buffer[digits] = '\0'; 

    do 
    { 
	digits -= 1; 
	buffer[digits] = (i % 10) + '0'; 
	i /= 10; 
    } 
    while (digits > 0); 
}

inline int fastLengthAsAscii (int n) {

    int digits = 1;

    while (n >= 10) {
	digits += 1;
	n /= 10;
    }

    return (digits);
}

    /* linearize a string */

inline char *linearize_string (char *bp, char *string) {

    UINT_32 hostLong;
    UINT_32 netLong;

    if (string != NULL) {

	hostLong = strlen (string) + 1;
	netLong  = htonl (hostLong);
	bp = fast_memcpy (bp, (char *) &netLong, sizeof(UINT_32));
	bp = fast_memcpy (bp, string, hostLong);

    } else {

	netLong = 0;
	bp = fast_memcpy (bp, (char *) &netLong, sizeof(UINT_32));
    }

    return (bp);
}

    /* break data out of a buffer */

char *breakout_ip (char *bp, char *end_bp, UINT_32 &value);
char *breakout_short (char *cp, char *end_bp, UINT_16 &value);
char *breakout_long (char *bp, char *end_bp, UINT_32 &value);
char *breakout_string (char *bp, char *end_bp, char **string);
char *breakout_byte (char *bp, char *end_bp, UINT_8 &value);

    /* compare strings */

int strcmpNullAndEmpty (const char *s1, const char *s2);

#endif
