/* Agent Tcl
   Bob Gray
   10 January 1996

   genVersion.cc

   This file defines the major and minor numbers for this Agent Tcl version.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "genVersion.h"
#include "genUtility.h"

/* Version::Version

   Purpose: These procedures are the constructors for class Version.
*/

Version::Version (void):
    m_name (NULL),
    m_major (0),
    m_minor (0),
    m_type  (e_ALPHA)
{
    // empty
}

Version::Version (DynamicString newName, int newMajor, int newMinor, Version::ReleaseType newType)
{
    m_name  = newName;
    m_major = newMajor;
    m_minor = newMinor;
    m_type  = newType;
}

Version::Version (const Version& version)
{
    m_name  = version.m_name;
    m_major = version.m_major;
    m_minor = version.m_minor;
    m_type  = version.m_type;
}

/* Version::operator=

   Purpose: This procedure is the assignment operator for class Version.
*/

Version& Version::operator= (const Version& version)
{
    if (&version != this) {
	m_name  = version.m_name;
	m_major = version.m_major;
	m_minor = version.m_minor;
	m_type  = version.m_type;
    }

    return (*this);
}

/* Version::update

   Purpose: Update the version information
*/

void Version::update (DynamicString newName, int newMajor, int newMinor, Version::ReleaseType newType)
{
	/* assertions on the parameters */

    assert (newMajor >= 0);
    assert (newMinor >= 0);
    assert ((newType == e_ALPHA) || (newType == e_BETA) || (newType == e_PRODUCTION));
 
	/* initialize */

    m_name  = newName;
    m_major = newMajor;
    m_minor = newMinor;
    m_type  = newType;
}

/* Version::~Version

    Purpose: This procedure is the destructor for class Version.
*/

Version::~Version ()
{
    // empty
}
