/* Agent Tcl
   Bob Gray
   10 January 1996

   genVersion.h

   This file defines the Version structure.

   Copyright (c) 1995-1997, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _GEN_VERSION_H
#define _GEN_VERSION_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _SUPP_DSTRING_H
#include "suppDString.h"		// DynamicString
#endif

    /* version information */

struct Version
{
    enum ReleaseType {
	e_ALPHA = 0,
	e_BETA = 1,
	e_PRODUCTION = 2
    };

    DynamicString m_name;   /* symbolic name                           */
    int m_major;            /* major release number of the interpreter */
    int m_minor;            /* minor release number of the interpreter */
    ReleaseType m_type;     /* ALPHA, BETA or PRODUCTION               */

	/* constructors */

    Version (void);
    Version (DynamicString name, int major, int minor, ReleaseType type);
    Version (const Version& version);

	/* assignment operator */

    Version& operator= (const Version& version);

	/* update */

    void update (DynamicString name, int major, int minor, ReleaseType type);

	/* destructor */

   ~Version ();
};

#endif
