/* Agent Tcl
   Bob Gray
   26 January 1997

   mesgMachId.h

   This file defines the class MachineId.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _MESG_MACH_ID_H
#define _MESG_MACH_ID_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_PORTING_H
#include "platPorting.h"	// UNKNOWN_IP 
#endif
#ifndef _PLAT_PORTING_H
#include "platSizes.h"		// UINT_32 
#endif
#ifndef _SUPP_DSTRING_H
#include "suppDString.h"         // DynamicString class
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN 
#endif

    /* machine identification */

class MachineId        
{
    DynamicString m_name;    // machine name
    UINT_32 m_ip;            // IP address of the machine

public:

	/* constructors */

    MachineId (void):
	m_name (),
	m_ip (UNKNOWN_IP)
    {
	// empty
    }

    MachineId (const MachineId &id):
	m_name (id.m_name),
	m_ip (id.m_ip)
    {
	// empty
    }

    MachineId (const DynamicString &name, UINT_32 ip = UNKNOWN_IP):
	m_name (name),
	m_ip (ip)
    {
	// empty
    }
  
	/* overload the assignment operator */

    MachineId& operator= (const MachineId& id) {

	if (this != &id) {
	    m_name = id.m_name;
	    m_ip = id.m_ip; 
	}

	return (*this);
    }

	/* destructor */
 
   ~MachineId () {};

	/* get and set operations */

    DynamicString getName (void) const {
	return (m_name);
    }

    UINT_32 getIp (void) const {
	return (m_ip);
    }

    void setName (DynamicString name) {
	m_name = name;
    }

    void setIp (UINT_32 ip) {
	m_ip = ip;
    }

	/* is the machine identification empty */

    BOOLEAN isEmpty (void) const {
	return (m_name.isEmpty() && (m_ip == UNKNOWN_IP)) ? e_TRUE : e_FALSE;
    }
};

#endif
