/* Agent Tcl
   Bob Gray
   25 January 1995

   mesgPort.h

   This file defines the RemotePort class.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _MESG_PORT_H
#define _MESG_PORT_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_PORTING_H
#include "platPorting.h"
#endif
#ifndef _PLAT_DELETE_H
#include "platDelete.h"		// DELETE_OBJECT and DELETE_ARRAY_OBJECT
#endif
#ifndef _PLAT_SIZES_H
#include "platSizes.h"
#endif
#ifndef _SUPP_STRINGS_H
#include "suppStrings.h"
#endif

    /* a port identification */

struct RemotePort  
{
    char *machine;       /* machine name              */
    UINT_32 ip;          /* IP address of the machine */
    int port;            /* port number               */

	/* constructors */

    RemotePort (char *p_machine, UINT_32 p_ip, int p_port):
	machine		(strcpyWithAlloc (p_machine)),
	ip		(p_ip),
	port		(p_port)
    {
	/* empty */
    };
	
    RemotePort (const RemotePort &p_port):
	machine		(strcpyWithAlloc (p_port.machine)),
	ip		(p_port.ip),
	port		(p_port.port)
    {
	/* empty */
    };

    RemotePort& operator= (const RemotePort& newPort) {

	if (this != &newPort) {
	    DELETE_ARRAY_OBJECT(machine);
	    machine = strcpyWithAlloc (newPort.machine);
	    ip = newPort.ip;
	    port = newPort.port;
	}

	return (*this);
    };

    RemotePort (void):
	machine		((char *) NULL),
	ip		(0),
	port		(0)
    {
	/* empty */
    };

	/* destructor */

   ~RemotePort () {
	DELETE_ARRAY_OBJECT(machine);
    };
};

#endif
