/* Agent Tcl
   Bob Gray
   25 January 1997

   platPerThread.cc

   This file implements class PerThreadPointer which defines a single "storage
   location" that can store a distinct value for each active thead.

   Copyright (c) 1995-1999, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif 

#include "platPorting.h"	// NULL
#include "platDelete.h"		// DELETE_OBJECT and DELETE_ARRAY_OBJECT
#include "platExclusion.h"	// MonitorLock
#include "platThread.h"		// ThreadId
#include "platPerThread.h"

#ifdef FIX_LATER
/*
 * PerThreadPointer is quite inefficient -- it does a linear scan through
 * the list to find the ThreadId and associated value
 */
#endif

/* 
 * associate a pointer with a ThreadId
 */

void PerThreadPointer::setValue (ThreadId tid, void *value) 
{
    Guard guard (lock);
    TidToPointer *entry = new TidToPointer ();
    entry -> tid        = tid;
    entry -> value      = value;
    entry -> next       = list;
    list                = entry;
}

/*
 * get the pointer associated with a ThreadId (and REMOVE the ThreadId 
 * from the table)
 */

void *PerThreadPointer::getValue (ThreadId tid) 
{
    TidToPointer *tp;
    void *value = NULL;
    TidToPointer *previous = NULL; 

    Guard guard (lock);

    for (tp = list; tp != NULL; previous = tp, tp = tp -> next) {

	if (tp -> tid == tid) {

	    value = tp -> value;

	    if (tp == list) {
		list = tp -> next;
	    } else {
		previous -> next = tp -> next;
	    }

	    DELETE_OBJECT(tp);
	    break;
	}
    }

    return (value);
}

/* 
 * get the pointer associated with a ThreadId
 */

void *PerThreadPointer::peekAtValue (ThreadId tid)
{
    TidToPointer *tp;
    void *value = NULL;

    Guard guard (lock);

    for (tp = list; tp != NULL; tp = tp -> next) {
	if (tp -> tid == tid) {
	    value = tp -> value;
	    break;
	}
    }

    return (value);
}
