/* Agent Tcl
   Bob Gray
   16 November 1996

   platInterrupt.cc

   This file implements a reliable signal function "install_signal".  This
   function is based on the examples in "UNIX Network Programming" by
   W. Richard Stevens [Prentice-Hall, 1990].

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platInterrupt.h"

const char *SignalHandlers::SignoToString (int signo)
{
    const char *s;

    switch (signo) {

#ifdef SIGBUS
	case SIGBUS:
	    s = "SIGBUS";
	    break;
#endif

#ifdef SIGABORT
	case SIGABORT:
	    s = "SIGABORT";
	    break;
#endif

#ifdef SIGABRT
	case SIGABRT:
	    s = "SIGABRT";
	    break;
#endif

#ifdef SIGALRM
	case SIGALRM:
	    s = "SIGALRM";
	    break;
#endif

#ifdef SIGFPE
	case SIGFPE:
	    s = "SIGFPE";
	    break;
#endif

#ifdef SIGHUP
	case SIGHUP:
	    s = "SIGHUP";
	    break;
#endif

#ifdef SIGILL
	case SIGILL:
	    s = "SIGILL";
	    break;
#endif

#ifdef SIGINT
	case SIGINT:
	    s = "SIGINT";
	    break;
#endif

#ifdef SIGPIPE
	case SIGPIPE:
	    s = "SIGPIPE";
	    break;
#endif

#ifdef SIGQUIT
	case SIGQUIT:
	    s = "SIGQUIT";
	    break;
#endif

#ifdef SIGSEGV
	case SIGSEGV:
	    s = "SIGSEGV";
	    break;
#endif

#ifdef SIGTERM
	case SIGTERM:
	    s = "SIGTERM";
	    break;
#endif

#ifdef SIGUSR1
	case SIGUSR1:
	    s = "SIGUSR1";
	    break;
#endif

#ifdef SIGUSR2
	case SIGUSR2:
	    s = "SIGUSR2";
	    break;
#endif

#ifdef SIGCHLD
	case SIGCHLD:
	    s = "SIGCHLD";
	    break;
#endif

#ifdef SIGCLD
#if SIGCHLD != SIGCLD
	case SIGCLD:
	    s = "SIGCLD";
	    break;
#endif
#endif

#ifdef SIGCONT
	case SIGCONT:
	    s = "SIGCONT";
	    break;
#endif

#ifdef SIGTSTP
	case SIGTSTP:
	    s = "SIGTSTP";
	    break;
#endif

#ifdef SIGTTIN
	case SIGTTIN:
	    s = "SIGTTIN";
	    break;
#endif

#ifdef SIGTTOU 
	case SIGTTOU:
	    s = "SIGTTOU";
	    break;
#endif

	default:
	    s = "UNKNOWN";
	    break;
    }

    return (s);
}
