/* Agent Tcl
   Bob Gray
   16 November 1996

   platMemdebug.cc

   This file defines a debugging version of the new and delete operators.
   It is not used in normal compilation.
 
   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

void *operator new (size_t size)
{
    void *ptr = (void *) malloc (size);
    printf ("NEW ptr ==> %x\n", (unsigned) ptr);
    return (ptr);
}

void operator delete (void *ptr) 
{
    printf ("DEL ptr ==> %x\n", (unsigned) ptr);

    if (ptr != (void *) NULL) {
        free (ptr);
    }
}
