/* Agent Tcl
   Bob Gray
   16 November 1996

   platSocket.cc

   This file implements socket-related functions.

   Copyright (c) 1995-1996, Bob Gray, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "platPorting.h"
#include "platSocket.h"

/* SocketIO::markAsynchronous

   Purpose: Turn on asynchronous I/O for a socket

     Input: sockfd = the socket descriptor
		     (int)

    Output: The procedure returns e_ControlError on error and e_Ok otherwise.
*/

SocketIO::SocketErrors SocketIO::markAsynchronous (int sockfd)
{
#ifdef FASYNC
 
    int flags;

    if (fcntl (sockfd, F_SETOWN, getpid()) < 0) {
	return e_ControlError;
    }

    if ((flags = fcntl (sockfd, F_GETFL, 0)) < 0) {
	return e_ControlError;
    }

    if (fcntl (sockfd, F_SETFL, flags | FASYNC) < 0) {
	return e_ControlError;
    }

    return e_Ok;

#else

    int flags;

    flags = getpid();

    if (ioctl (sockfd, SIOCSPGRP, &flags) < 0) {
	return e_ControlError;
    }

    flags = 1;

    if (ioctl (sockfd, FIOASYNC, &flags) < 0) {
	return e_ControlError;
    }

    return e_Ok;

#endif
}

/* SocketIO::markSynchronous

   Purpose: Turn off asynchronous I/O for a socket

     Input: sockfd = the socket descriptor
		     (int)

    Output: The procedure returns e_ControlError on error and e_Ok otherwise.
*/

SocketIO::SocketErrors SocketIO::markSynchronous (int sockfd)
{
#ifdef FASYNC
 
    int flags;

    if ((flags = fcntl (sockfd, F_GETFL, 0)) < 0) {
	return e_ControlError;
    }

    if (fcntl (sockfd, F_SETFL, flags & ~FASYNC) < 0) {
	return e_ControlError;
    } 

    return e_Ok;

#else

    int flags = 0;

    if (ioctl (sockfd, FIOASYNC, &flags) < 0) {
	return e_ControlError;
    }

    return e_Ok;

#endif
}
