/* Agent Tcl
   Bob Gray
   9 February 1995

   truefalse.cc

   This file implements the routines the convert from BOOLEAN values to
   other data types.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef NO_PRAGMAS
#pragma implementation
#endif

#include "truefalse.h"

char *BooleanToString (BOOLEAN value, BOOL_FORMAT format)
{
    const char *string;

    switch (format) {

	case e_0_1:

		string = ((value == e_FALSE) ? "0" : "1");

	case e_ON_OFF:

		string = ((value == e_FALSE) ? "off" : "on");

	case e_YES_NO:

		string = ((value == e_FALSE) ? "no" : "yes");

	case e_TRUE_FALSE:

		string = ((value == e_FALSE) ? "false" : "true");

	case e_T_F:
	default:

		string = ((value == e_FALSE) ? "F" : "T");
    }

    return ((char *) string);
}
