/* Agent Tcl
   Bob Gray
   25 January 1997

   platPerThread.h

   This file defines class PerThreadPointer which defines a single "storage
   location" that can store a distinct pointer for each active thead.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_PER_THREAD_H
#define _PLAT_PER_THREAD_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_PORTING_H
#include "platPorting.h"	// NULL
#endif
#ifndef _PLAT_EXCLUSION_H
#include "platExclusion.h"	// MonitorLock
#endif
#ifndef _PLAT_THREAD_H
#include "platThread.h"		// ThreadId
#endif

struct TidToPointer
{
    ThreadId tid;	 // thread identity
    void *value;         // value
    TidToPointer *next;  // next value in the list
};

class PerThreadPointer
{
     TidToPointer *list;
     MonitorLock lock;

public:

	// associate a pointer with a ThreadId

     void setValue (ThreadId tid, void *value);

	// get the pointer associated with a ThreadId (and REMOVE the 
	// ThreadId from the table)

     void *getValue (ThreadId tid);

	// get the pointer associated with a ThreadId

    void *peekAtValue (ThreadId tid);

	// constructor

    PerThreadPointer (void):
	list (NULL)
    {
	// empty
    }

#ifdef FIX_LATER
	// A destructor would be a really good idea.
#endif
};

#endif
