/* Agent Tcl
   Bob Gray
   29 September 1995

   platThread.h

   This file defines the class which handles the creation and execution of
   threads.

   Copyright (c) 1995-1998, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_THREAD_H
#define _PLAT_THREAD_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_SIZES_H
#include "platSizes.h"		// UINT_32
#endif
#ifndef _TRUEFALSE_H
#include "truefalse.h"		// BOOLEAN
#endif

    /* forward declarations */

class ThreadImp;

    /* thread self */

struct ThreadId {

    UINT_32 m_id[2];		// thread identification

	// constructor

    ThreadId (void) {
	m_id[0] = 0;
	m_id[1] = 1;
    }

	// copy constructor

    ThreadId (const ThreadId &id) {
	m_id[0] = id.m_id[0];
	m_id[1] = id.m_id[1];
    }

	// assignment operator

    ThreadId& operator= (const ThreadId &id) {

	if (this != &id) {
	    m_id[0] = id.m_id[0];
	    m_id[1] = id.m_id[1];
	}

	return (*this);
    }
};

inline int operator== (ThreadId x, ThreadId y) 
{
    return ((x.m_id[0] == y.m_id[0]) && (x.m_id[1] == y.m_id[1])) ? 1 : 0;
}

inline int operator!= (ThreadId x, ThreadId y)
{
    return ((x.m_id[0] != y.m_id[0]) || (x.m_id[1] != y.m_id[1])) ? 1 : 0;
}

    /* thread */

class ThreadBody
{
public:

    virtual void run (void) = 0;
    virtual ~ThreadBody() {};
};

class Thread
{
private:	// data

    ThreadId   m_id;				// thread identification
    ThreadImp *m_this;				// implementation details

private:	// methods

    Thread& operator= (const Thread&) {		// not implemented
	return (*this);
    }
    
public:		// enumarated types

    enum ThreadType {
	e_DAEMON_THREAD		= 0x0,
	e_CLIENT_THREAD		= 0x1 
    };

public:		// methods

	// constructors and destructor

    Thread (const char *name, ThreadType threadType, ThreadBody *threadBody);
    Thread (const Thread& thread);
    virtual ~Thread ();

	// resume thread execution

    void resume (void);
  
	// get the id of the thread

    ThreadId getThreadId (void) {
	return (m_id);
    }

	// get the id of the currently-executing thread

    static ThreadId self (void);

	// exit the current thread

    static void exit (void);
};

#endif
