/* Agent Tcl
   Bob Gray
   19 December 1998

   platDelete.h

   This file defines two macros DELETE_OBJECT and DELATE_ARRAY_OBJECT,
   which use the standard "delete" operation to delete the object, but
   then NULL out the point.  The goal of these routines is to turn some
   memory corruption errors into segmentation faults instead.  The actual
   "delete" operator should appear no where in the code base.

   Copyright (c) 1998-1999, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_DELETE_H
#define _PLAT_DELETE_H

#ifndef _PLAT_PORTING
#include "platPorting.h"	// NULL
#endif

#define DELETE_OBJECT(pointer) \
	{ delete pointer; char **ptr = (char **) &(pointer); *ptr = (char *) NULL; }

#define DELETE_OBJECT_WITH_CAST(cast,pointer) \
	{ delete ((cast) pointer); char **ptr = (char **) &(pointer); *ptr = (char *) NULL; }

#define DELETE_ARRAY_OBJECT(pointer) \
	{ delete [] pointer; char **ptr = (char **) &(pointer); *ptr = (char *) NULL; }

#endif
