/* Agent Tcl
   Bob Gray
   9 February 1995

   platInterrupt.h

   This file defines a reliable signal function "install_signal".  This
   function is based on the examples in "UNIX Network Programming" by
   W. Richard Stevens [Prentice-Hall, 1990].

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_INTERRUPT_H
#define _PLAT_INTERRUPT_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

class SignalHandlers 
{
public:

    typedef void *ClientData;
    typedef void (*funcType) (int, ClientData);

	// initialize the signal handling subsystem

#ifdef FIX_LATER
	/* 
	 * initializeSignals should be called "automatically" whenever we
	 * are in an environment that requires some kind of initialization
	 * before signals will work as desired (e.g., a multi-threaded
	 * environment in which we have a signal-handling thread).
	 */
#endif

    static void initializeSignals 
	(void);

	// install a signal handler
	
#ifdef FIX_LATER
    /*
     * we need to define our own SIG_IGN and SIG_DFL constants to pass
     * in as the "func" argument
     */
#endif

    static int install_signal
	(int signo, funcType func, ClientData clientData);

    static int install_signal_intr
	(int signo, funcType func, ClientData clientData);

	// convert a signal number into a short descriptive name

    static const char *SignoToString
	(int signo);
};

#endif
