/* Agent Tcl
   Bob Gray
   17 April 1997

   platMath.h

   This file defines a set of common math operations.

   Copyright (c) 1995-1997, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _PLAT_MATH_H
#define _PLAT_MATH_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#ifndef _PLAT_SIZES
#include "platSizes.h"		// UINT_32, INT_32
#endif

class MathUtil
{
    public: 

		// min and max

	static UINT_32 min (UINT_32 m, UINT_32 n) {
	    return (m < n ? m : n);
	}

	static INT_32 min (INT_32 m, INT_32 n) {
	    return (m < n ? m : n);
	}

	static UINT_32 max (UINT_32 m, UINT_32 n) {
	    return (m > n ? m : n);
	}

	static INT_32 max (INT_32 m, INT_32 n) {
	    return (m > n ? m : n);
	}

	  	// add with a ceiling

	static UINT_32 addWithCeiling (UINT_32 m, UINT_32 n, UINT_32 ceiling = MAX_U32) {

	    UINT_32 sum;
	    UINT_32 nmax = max (m, n);
	    UINT_32 nmin = min (m, n);

	    if (nmin > MAX_U32 - nmax) {
		sum = MAX_U32;
	    } else {
		sum = nmin + nmax;
	    }

	    if (sum > ceiling) {
		sum = ceiling;
	    }

	    return (sum);
	}

	static INT_32 addWithCeiling (INT_32 m, INT_32 n, INT_32 ceiling = MAX_32) {

	    INT_32 sum;
	    INT_32 nmax = max (m, n);
	    INT_32 nmin = min (m, n);

	    if ((nmax < 0) && (nmin < 0)) {

		    // both negative

		if (nmax < MIN_32 - nmin) {
		    sum = MIN_32;
		} else {
		    sum = nmax + nmin;
		}

	    } else if (nmin < 0) {

		    // one nonzero and the other negative

		sum = nmax + nmin;

	    } else {

		    // both nonzero 

		if (nmin > MAX_32 - nmax) {
		    sum = MAX_32;
		} else {
		    sum = nmax + nmin;
		}
	    }

	    if (sum > ceiling) {
		sum = ceiling;
	    } 

	    return (sum);
	}
};

#endif
