/* Agent Tcl
   Bob Gray
   24 May 1996

   platPorting.h

   "This header file handles porting issues that occur because
   of differences between systems.  It reads in UNIX-related
   header files and sets up UNIX-related macros for Agent Tcl's 
   UNIX core.  It should be the only file that contains #ifdefs 
   to handle different flavors of UNIX.  This file sets up the
   union of all UNIX-related things needed by any of the Tcl
   core files.  This file depends on configuration #defines such
   as NO_DIRENT_H that are set up by the "configure" scripts". 

   The text above and much of this file was taken from the Tcl 7.5 source
   code distribution from Sun Microsystems.  This source code is freely
   usuable under the Sun license.
*/

#ifndef _PLAT_PORTING_H
#define _PLAT_PORTING_H

#ifndef NO_PRAGMAS
#pragma interface
#endif

#undef EXTERN

#ifdef __cplusplus
#define EXTERN extern "C"
#else
#define EXTERN extern
#endif

/*
 * generic includes -- all with include guards
 */

#ifndef _INCLUDE_ASSERT_H
#   define _INCLUDE_ASSERT_H
#   include <assert.h>
#endif
#ifdef HAVE_MALLOC_H
#   ifndef _INCLUDE_MALLOC_H
#	define _INCLUDE_MALLOC_H
#	include <malloc.h>
#   endif
#endif
#ifndef _INCLUDE_STDIO_H
#   define _INCLUDE_STDIO_H
#   include <stdio.h>
#endif
#ifdef NO_LIMITS_H
#   ifndef _INCLUDE_LIMITS_H
#	define _INCLUDE_LIMITS_H
#	include "compat/limits.h"
#   endif
#else
#   ifndef _INCLUDE_LIMITS_H
#	define _INCLUDE_LIMITS_H
#       include <limits.h>
#   endif
#endif
#ifdef NO_STDLIB_H
#   ifndef _INCLUDE_STDLIB_H
#	define _INCLUDE_STDLIB_H
#	include "compat/stdlib.h"
#   endif
#else
#   ifndef _INCLUDE_STDLIB_H
#	define _INCLUDE_STDLIB_H
#	include <stdlib.h>
#   endif
#endif
#ifndef _INCLUDE_ERRNO_H
#   define _INCLUDE_ERRNO_H
#   include <errno.h>
#endif
#ifndef _INCLUDE_FCNTL_H
#   define _INCLUDE_ERRNO_H
#   include <fcntl.h>
#endif
#ifdef HAVE_NET_ERRNO_H
#   ifndef _INCLUDE_NET_ERRNO_H
#	define _INCLUDE_NET_ERRNO_H
#	include <net/errno.h>
#   endif
#endif
#ifndef _INCLUDE_PWD_H
#   define _INCLUDE_PWD_H
#   include <pwd.h>
#endif
#ifndef _INCLUDE_GRP_H
#   define _INCLUDE_GRP_H
#   include <grp.h>
#endif
#ifndef _INCLUDE_SIGNAL_H
#   define _INCLUDE_SIGNAL_H
#   include <signal.h>
#endif
#ifndef _INCLUDE_SYS_PARAM_H
#   define _INCLUDE_SYS_PARAM_H
#   include <sys/param.h>
#endif
#ifndef _INCLUDE_SYS_TYPES_H
#   define _INCLUDE_SYS_TYPES_H
#   include <sys/types.h>
#endif
#ifndef _INCLUDE_SYS_FILE_H
#   define _INCLUDE_SYS_FILE_H
#   include <sys/file.h>
#endif
#ifndef _INCLUDE_SYS_IOCTL_H
#    define _INCLUDE_SYS_IOCTL_H
#    include <sys/ioctl.h>
#endif

/*
 * include the time header files 
 */

#include <sys/times.h>

#if TIME_WITH_SYS_TIME
#   include <sys/time.h>
#   include <time.h>
#else
#   if HAVE_SYS_TIME_H
#       include <sys/time.h>
#   else
#       include <time.h>
#   endif
#endif

/*   
 * include sys/wait.h if it is present
 */

#ifndef NO_SYS_WAIT_H
#   ifndef _INCLUDE_SYS_WAIT_H
#	define _INCLUDE_SYS_WAIT_H
#	include <sys/wait.h>
#   endif
#endif

/*
 * include dirent.h if it is present
 */

#ifndef NO_DIRENT_H 
#    ifndef _INCLUDE_DIRENT_H
#	define _INCLUDE_DIRENT_H
#	include <dirent.h>
#    endif
#endif

/*
 * include unistd.h if it is present 
 */

#ifdef HAVE_UNISTD_H
#   ifndef _INCLUDE_UNISTD_H
#	define _INCLUDE_UNISTD_H
#	include <unistd.h>
#   endif
#else
#   ifndef _INCLUDE_UNISTD_H
#	define _INCLUDE_UNISTD_H
#	include "compat/unistd.h"
#   endif
#endif

/*
 * include crypt.h if it is present
 */

#ifdef HAVE_CRYPT_H
#   ifndef _INCLUDE_CRYPT_H
#	define _INCLUDE_CRYPT_H
#	include <crypt.h>
#endif
#endif

     /* include the string and character header files */

#ifdef HAVE_STRING_H
#   ifndef _INCLUDE_STRING_H
#	define _INCLUDE_STRING_H
#	include <string.h>
#   endif
#else
#   ifndef _INCLUDE_STRING_H
#	define _INCLUDE_STRING_H
#	include <compat/string.h>
#   endif
#endif
#ifdef HAVE_STRINGS_H
#   ifndef _INCLUDE_STRINGS_H
#	define _INCLUDE_STRINGS_H
#	include <strings.h>
#   endif
#endif
#ifdef HAVE_BSTRING_H
#   ifndef _INCLUDE_BSTRING_H
#	define _INCLUDE_BSTRING_H
#	include <bstring.h>
#   endif
#endif
#ifdef HAVE_CTYPE_H
#   ifndef _INCLUDE_CTYPE_H
#	define _INCLUDE_CTYPE_H
#	include <ctype.h>
#   endif
#endif

/*
 * socket support stuff - all with include guards.  This likely needs more 
 * work to parameterize for each system.
 */

#ifndef _INCLUDE_SYS_SOCKET_H
#   define _INCLUDE_SYS_SOCKET_H
#   include <sys/socket.h>	/* struct sockaddr, SOCK_STREAM, ... */
#endif
#ifndef _INCLUDE_SYS_UTSNAME_H
#   define _INCLUDE_SYS_UTSNAME_H
#   include <sys/utsname.h>	/* uname system call. */
#endif
#ifndef _INCLUDE_SYS_NETINET_IN_H
#   define _INCLUDE_SYS_NETINET_IN_H
#   include <netinet/in.h>	/* struct in_addr, struct sockaddr_in */
#endif
#ifndef _INCLUDE_SYS_NETINET_TCP_H
#   define _INCLUDE_SYS_NETINET_TCP_H
#   include <netinet/tcp.h>     /* TCP_NODELAY, etc. on some machines */	
#endif
#ifndef _INCLUDE_ARPA_INET_H
#   define _INCLUDE_ARPA_INET_H
#   include <arpa/inet.h>	/* inet_ntoa() */
#endif
#ifndef _INCLUDE_NETDB_H
#   define _INCLUDE_NETDB_H
#   include <netdb.h>
#endif

/*
 * include sys/select.h, sys/stat.h, sys/uio.h, sys/un.h, sys/ioctl.h,
 * sys/filio.h and sys/stat.h if they exist
 */

#ifdef HAVE_SYS_SELECT_H
#   ifndef _INCLUDE_SYS_SELECT_H
#	define _INCLUDE_SYS_SELECT_H
#	include <sys/select.h>
#   endif
#endif

#ifdef HAVE_SYS_UIO_H
#    ifndef _INCLUDE_SYS_UIO_H
#	define _INCLUDE_SYS_UIO_H
#	include <sys/uio.h>
#    endif
#endif

#ifdef HAVE_SYS_FILIO_H
#    ifndef _INCLUDE_SYS_FILIO_H
#	define _INCLUDE_SYS_FILIO_H
#	include <sys/filio.h>
#    endif
#endif

#ifndef _INCLUDE_SYS_STAT_H
#    define _INCLUDE_SYS_STAT_H
#    include <sys/stat.h>
#endif

#ifdef HAVE_SYS_UN_H
#    ifndef _INCLUDE_SYS_UN_H
#       define _INCLUDE_SYS_UN_H
#       include <sys/un.h>
#    endif
#endif

#ifdef HAVE_SYS_IOCTL_H
#    ifndef _INCLUDE_SYS_IOCTL_H
#       define _INCLUDE_SYS_IOCTL_H
#       include <sys/ioctl.h>
#    endif
#endif

/*
 * NeXT doesn't define O_NONBLOCK so #define it here if necessary.
 */

#ifndef O_NONBLOCK
#   define O_NONBLOCK 0x80
#endif

/*
 * HPUX needs the flag O_NONBLOCK to get the right non-blocking I/O
 * semantics while most other systems need O_NDELAY.  Define the
 * constant NBIO_FLAG to be one of these
 */

#ifdef HPUX
#  define NON_BLOCKING_FLAG O_NONBLOCK
#else
#  define NON_BLOCKING_FLAG O_NDELAY
#endif

/*
 * Not all systems declare the errno variable in errno.h so this
 * file does it explicitly.  The list of system error messages also
 * isn't generally declared in a header file anywhere.  Note the 
 *
 *   #ifndef errno
 *
 * to handle those systems where errno is a macro.
 */

#ifndef errno
extern int errno;
#endif

/*
 * The type of the status returned by wait varies from UNIX system
 * to UNIX system.  The macro below defines it:
 */

#ifdef _AIX
#   define WAIT_STATUS_TYPE pid_t
#else
#ifndef NO_UNION_WAIT
#   define WAIT_STATUS_TYPE union wait
#else
#   define WAIT_STATUS_TYPE int
#endif
#endif

/*
 * Supply definitions for macros to query wait status if not already
 * defined in header files above.
 */

#ifndef WIFEXITED
#   define WIFEXITED(stat)  (((*((int *) &(stat))) & 0xff) == 0)
#endif

#ifndef WEXITSTATUS
#   define WEXITSTATUS(stat) (((*((int *) &(stat))) >> 8) & 0xff)
#endif

#ifndef WIFSIGNALED
#   define WIFSIGNALED(stat) (((*((int *) &(stat)))) && ((*((int *) &(stat))) == ((*((int *) &(stat))) & 0x00ff)))
#endif

#ifndef WTERMSIG
#   define WTERMSIG(stat)    ((*((int *) &(stat))) & 0x7f)
#endif

#ifndef WIFSTOPPED
#   define WIFSTOPPED(stat)  (((*((int *) &(stat))) & 0xff) == 0177)
#endif

#ifndef WSTOPSIG
#   define WSTOPSIG(stat)    (((*((int *) &(stat))) >> 8) & 0xff)
#endif

/*
 * Define constants for waitpid() system call if they aren't defined
 * by a system header file.
 */

#ifndef WNOHANG
#   define WNOHANG 1
#endif
#ifndef WUNTRACED
#   define WUNTRACED 2
#endif

/*
 * Supply macros for seek offsets if they're not already provided by
 * an include file.
 */

#ifndef SEEK_SET
#   define SEEK_SET 0
#endif

#ifndef SEEK_CUR
#   define SEEK_CUR 1
#endif

#ifndef SEEK_END
#   define SEEK_END 2
#endif

/*
 * The stuff below is needed by the "time" command.  If this
 * system has no gettimeofday call, then must use times and the
 * CLK_TCK #define (from sys/param.h) to compute elapsed time.
 * Unfortunately, some systems only have HZ and no CLK_TCK, and
 * some might not even have HZ.
 */

#ifdef NO_GETTOD
#   include <sys/times.h>
#   include <sys/param.h>
#   ifndef CLK_TCK
#       ifdef HZ
#           define CLK_TCK HZ
#       else
#           define CLK_TCK 60
#       endif
#   endif
#else
#   ifdef HAVE_BSDGETTIMEOFDAY
#	define gettimeofday BSDgettimeofday
#   endif
#endif

#ifdef GETTOD_NOT_DECLARED
EXTERN int gettimeofday (struct timeval *tp, struct timezone *tzp);
#endif

/*
 * Define access mode constants if they aren't already defined.
 */

#ifndef F_OK
#    define F_OK 00
#endif
#ifndef X_OK
#    define X_OK 01
#endif
#ifndef W_OK
#    define W_OK 02
#endif
#ifndef R_OK
#    define R_OK 04
#endif

/*
 * Define FD_CLOEEXEC (the close-on-exec flag bit) if it isn't
 * already defined.
 */

#ifndef FD_CLOEXEC
#   define FD_CLOEXEC 1
#endif

/*
 * On systems without symbolic links (i.e. S_IFLNK isn't defined)
 * define "lstat" to use "stat" instead.
 */

#ifndef S_IFLNK
#   define lstat stat
#endif

/*
 * Define macros to query file type bits, if they're not already
 * defined.
 */

#ifndef S_ISREG
#   ifdef S_IFREG
#       define S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#   else
#       define S_ISREG(m) 0
#   endif
# endif
#ifndef S_ISDIR
#   ifdef S_IFDIR
#       define S_ISDIR(m) (((m) & S_IFMT) == S_IFDIR)
#   else
#       define S_ISDIR(m) 0
#   endif
# endif
#ifndef S_ISCHR
#   ifdef S_IFCHR
#       define S_ISCHR(m) (((m) & S_IFMT) == S_IFCHR)
#   else
#       define S_ISCHR(m) 0
#   endif
# endif
#ifndef S_ISBLK
#   ifdef S_IFBLK
#       define S_ISBLK(m) (((m) & S_IFMT) == S_IFBLK)
#   else
#       define S_ISBLK(m) 0
#   endif
# endif
#ifndef S_ISFIFO
#   ifdef S_IFIFO
#       define S_ISFIFO(m) (((m) & S_IFMT) == S_IFIFO)
#   else
#       define S_ISFIFO(m) 0
#   endif
# endif
#ifndef S_ISLNK
#   ifdef S_IFLNK
#       define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
#   else
#       define S_ISLNK(m) 0
#   endif
# endif
#ifndef S_ISSOCK
#   ifdef S_IFSOCK
#       define S_ISSOCK(m) (((m) & S_IFMT) == S_IFSOCK)
#   else
#       define S_ISSOCK(m) 0
#   endif
# endif

/*
 * Make sure that MAXPATHLEN is defined.
 */

#ifndef MAXPATHLEN
#   ifdef PATH_MAX
#       define MAXPATHLEN PATH_MAX
#   else
#       define MAXPATHLEN 2048
#   endif
#endif

/*
 * Make sure that L_tmpnam is defined.
 */

#ifndef L_tmpnam
#   define L_tmpnam 100
#endif

     /* the following macro defines the type of the mask arguments to select: */

#ifndef NO_FD_SET
#   define SELECT_MASK fd_set
#else
#   ifndef _AIX
	typedef long fd_mask;
#   endif
#   if defined(_IBMR2)
#	define SELECT_MASK void
#   else
#	define SELECT_MASK int
#   endif
#endif

/*
 * Define "NBBY" (number of bits per byte) if it's not already defined.
 */

#ifndef NBBY
#   define NBBY 8
#endif

/*
 * The following macro defines the number of fd_masks in an fd_set:
 */

#ifndef FD_SETSIZE
#   ifdef OPEN_MAX
#	define FD_SETSIZE OPEN_MAX
#   else
#	define FD_SETSIZE 256
#   endif
#endif
#if !defined(howmany)
#   define howmany(x, y) (((x)+((y)-1))/(y))
#endif
#ifndef NFDBITS
#   define NFDBITS NBBY*sizeof(fd_mask)
#endif
#define MASK_SIZE howmany(FD_SETSIZE, NFDBITS)

/*
 * Portable versions of FD_ZERO, FD_SET, FD_CLR and FD_ISSET
 */

extern void FDMASK_ZERO (fd_mask *mask);
extern void FDMASK_SET (int fd, fd_mask *mask);
extern void FDMASK_CLR (int fd, fd_mask *mask);
extern int FDMASK_ISSET (int fd, fd_mask *mask);
extern int FDMASK_INDEX (int fd);
extern fd_mask FDMASK_BIT (int fd);

/*
 * Define sig_atomic_t if necessary
 */

#ifdef NO_SIGATOMIC_T
typedef int sig_atomic_t;
#endif

/*
 * Variables provided by the C library:
 */

#if defined(_sgi) || defined(__sgi)
#define environ _environ
#endif
extern char **environ;

/*
 * At present (12/91) not all stdlib.h implementations declare strtod.
 * The declaration below is here to ensure that it's declared, so that
 * the compiler won't take the default approach of assuming it returns
 * an int.  There's no ANSI prototype for it because there would end
 * up being too many conflicts with slightly-different prototypes.
 */

extern double strtod();

/*
 * an unknown ip address
 */

#define UNKNOWN_IP 0xffffffff

/*
 * a better abort()
 */


#define	abort_with_message(string)					      \
    fprintf (stderr, "abort in line %d of file %s: %s\n", __LINE__, __FILE__, string); \
    abort ();

/*
 * gethostname declaration if needed
 */

#ifdef GETHOSTNAME_NOT_DECLARED
EXTERN int gethostname (char *, int);
#endif

/*
 * boolean_t declaration if needed
 */

#ifdef NO_BOOLEAN_T
typedef unsigned boolean_t;
#endif

/*
 * unsetenv declaration if needed
 */

#ifdef NO_UNSETENV_FUNCTION
EXTERN int unsetenv (char *);
#endif

#undef EXTERN
#endif /* _PLAT_PORTING_H */
